Anybody who’s seen Un Chien Andalou by Luis Buñuel is familiar with the cinematic technique.
A black man is being tortured by two white policemen, but we see him only from behind. We hear his screams. The police taunt him in a bored, indifferent way. We know he’s been water boarded, and, perhaps, beaten, but there’s not very much we can see by looking at the back of his head. The door opens. It’s a black messenger. The two policemen scream at him never to come in without knocking. The horrified expression on the messenger’s face tells us this isn’t the kinder, gentler torture we saw in Zero Dark Thirty. This is hard core Gestapo stuff. Later in the film we see what went on before the camera pulled away. The movie flashes back to the torture we had witnessed earlier, only, this time, we see it from the messenger’s point of view, from the front. The torture victim has had most of his face caved in. His eyeball has fallen out. It’s hanging down onto his cheek. His hands are broken. His body has been contorted so violently that even if he’s released — and we know he won’t be — he’ll spend the rest of his life in a wheel chair. He’s a dead man, moments away from the end.
A Dry White Season by Euzhan Palcy, the first black woman to direct a film for a major Hollywood studio, and the only woman ever to have directed Marlon Brando, is such a vivid depiction of apartheid South Africa that I’m surprised it’s not better known. Rarely have I seen a film that so perfectly captures the viciousness of a police state. Then again, perhaps I shouldn’t be surprised. Nelson Mandela’s funeral notwithstanding, we don’t talk much these days about the struggle against apartheid. The film itself, which is about the ways people avoid confronting reality, about the ways we manage to ignore the state violence that’s necessary for our wealth and privilege in a racist, colonial settler economy, is probably the best explanation about why it’s not better known.
The time is 1976, the year of the Soweto uprising. Donald Sutherland is Ben du Toit, a former rugby star with Suzette, a college age daughter, and Johan, a younger son. He teaches history at an exclusive, and, naturally, all white private school. Du Toit is a decent man with a good heart, but, like all white South Africans, he’s learned not to see what’s right in front of his nose. Du Toit’s world is placid, idyllic, sheltered. Soon, reality hits, and hits hard. Du Toit employs a gardener named Gordon Ngubene. Ngubene, in turn, has a son Johan’s age. The two boys are good friends. Ngubene doesn’t want his son getting involved in politics. But in the South Africa of the 1970s that’s easier said than done. Black men and boys don’t have the luxury of being apolitical. Jonathan, Ngubene’s son attends a segregated school. Du Toit is generous enough to pay his tuition, but the curriculum is Afrikaans, not English, an intentional policy that effectively isolates blacks from the larger world, and Jonathan wants none of it. He joins a protest. He’s caned. Gordon comes to du Toit for help, but du Toit doesn’t take him seriously. He doesn’t take the word of a black man seriously. He also knows, keep down inside, that once he sides with the black majority, his whole life will be turned upside down. Let it go, he advises. He doesn’t quite understand that Gordon can’t just let it go. Jonathan participates in the famous protest march that led to the Soweto massacre. The police pick him up. He’s sent to prison, where he dies under torture. Gordon comes back to Du Toit, who agrees to investigate.
The biggest strength of A Dry White Season is how well Euzhan Palcy communicates to us what a momentous event the Soweto protests were. The black majority is viciously repressed. But the white minority is terrified of the inevitable end of the apartheid regime. They close ranks. Du Toit’s white privilege has its limits. He’s warned, subtly at first, then not so subtly, that there’s a line he shouldn’t cross, that, once he does, he puts himself in danger. Du Toit knows this, but, to his credit, he presses on, helping Gordon find his son, and then, after Gordon himself is murdered, trying to get justice. He hires a famous anti-Apartheid lawyer named Ian McKenzie, Marlon Brando in a brilliant, almost forgotten performance. McKenzie, a flamboyant, William Kunstler style radical knows the “justice” system in South Africa is a sham. “Every time I win a case,” he warns Du Toit, “they just change the rules. Nevertheless, he decides to take the case, more for Du Toit’s education than out of any belief he’ll get justice for Gordon. What follows is the film’s best scene, one of the great courtroom scenes in all of cinema. Again and again, McKenzie demolishes the state’s witnesses. Again and again, the judge simply overrules him. Brando is just magnificent. Every once of his then considerable bulk expresses the absurdity of being a lawyer inside a corrupt legal system. His words and his manner have a revolutionary fire you never quite saw in Burn or in Viva Zapata, his 10 minutes on screen such a dominating presence you remember him long after he walks off stage.
But there will be no justice for Gordon. Nothing else in A Dry White Season quite matches Brando’s performance, but Donald Sutherland still manages to convey what it’s like for a man who’s taken the first step out of his gated, all white community, a first step that’s, in effect, a final step. There’s no going back. There’s no fence straddling. You can’t be a liberal in apartheid South Africa. You either stand for justice, and get crushed beneath the full weight of the police state, or you stand with the fascists. Du Toit stands for justice. His young son comes along. His wife and daughter side with the status quo. They just want things to go back to the way they were before the murder of Gordon’s son rudely intrudes on their sheltered existence. Suzette, Du Toit’s daughter, is a reprehensible human being who betrays her own father to the secret police, but, while we don’t understand the way she feels inside, we understand her motives. She wants the impossible, moral innocence in an unjust world. A Dry White Season demonstrates how, by her reluctance to get involved, she becomes one with the torturers, the murderers, and the police.