First Paper from Gemini/HST Galaxy Survey: It Takes More Than Aging to Shape A Galaxy
March 28, 2005
Can galaxies observed at very high redshifts (at a time when the universe was a fraction of its current age) evolve to look like today's nearby galaxies simply by growing older? The answer is no according to an international team of scientists led by Inger Jørgenson (Gemini Observatory) who used GMOS on Gemini North, combined with HST imaging data to survey distant galaxies and chart their evolution.
The team's results demonstrate that cluster galaxies closer to us are not aged versions of the kinds of early galaxies seen in distant clusters that existed when the universe was half its current age, about seven billion years ago. To evolve into galaxies like those we see in nearby clusters, these galaxies require more than just a single episode of star formation as current theories suggest — the distant early "progenitors" have to undergo a set of profound transformations that most likely include galaxy mergers and multiple episodes of star formation.
The team has just published the first in a series of papers based on data from the Gemini/HST Galaxy Cluster Project. The first cluster analyzed is RXJ0152.7-1357 and was discovered by the X-ray satellite ROSAT and lies at a redshift of 0.83 (Figure 1). The X-ray images from both the XMM satellite and the Chandra satellite show two sub-clumps of matter, and support the idea that the cluster is in the process of merging from two sub-clusters of roughly equal mass.
Figure 1 The central part of the galaxy cluster RXJ0152.7-1357, which lies at a redshift of 0.83, is shown in this HST/ACS archival data view. The image covers 75 × 45 arcseconds, which corresponds to about 0.6 × 0.35 megaparsecs. Most of the galaxies in the cluster appear as yellow/orange objects in this image, and most of these are elliptical galaxies. The many faint blue and very elongated objects are gravitationally lensed background galaxies. The gravitational lensing shows, in agreement with the X-ray data, that RXJ0152.7-1357 is a very massive cluster. The observations were done in three colors, r' (630nm), i' (775nm), and z' (925nm). These images are shown as blue (r'), green (i'), and red (z') to form the color image.
For the Gemini/HST Galaxy Cluster Project, a sample of 15 galaxy clusters with redshifts between 0.2 and 1 were chosen based on their X-ray luminosities. The sample is limited to clusters with X-ray luminosities larger than LX = 2 × 1044 ergs per second and is intended to be representative of rich galaxy clusters. The galaxies for which spectra were obtained can be several times less luminous than the Milky Way. GMOS spectra (Figure 2) have been obtained for 13 of the 15 clusters and HST data is currently available for more than half of them.
The main conclusion of the team's paper focusing on RXJ0152.7-1357 is that passive evolution may not be what makes galaxies look like they do today. If an early cluster's galaxies were to passively evolve—that is, if their stars just simply got older, with no new stars forming—the resulting galaxies would not look like those we see in large clusters at the current epoch, such as those in the Coma cluster. Instead, the team suggests that galaxies must undergo merger episodes with other galaxies. In addition, there must be new star formation, perhaps in the galaxies doing the merging.
There are galaxies in RXJ0152.7-1357 that show signs of a small amount of new star formation. They are located at the outskirts of the two sub-clumps in the process of forming the cluster. The massive “train wreck” of the two sub-clusters running into each other may have triggered the formation of new stars in galaxies that were otherwise done making stars.
Figure 2 (top, middle, bottom) Three spectra of galaxies in the cluster RXJ0152.7-1357 from GMOS-North are shown here. The top spectrum is of the brightest galaxy in the cluster (id=766). This galaxy has a spectrum typical of an old stellar population with no recent star formation. The middle spectrum (id=566) is one of a handful of galaxies that show very weak star formation and an abundance of young stars together with older stars. The weak emission line marked [OII] shows the presence of star formation, while the strong Balmer absorption Hδ and Hγ show the young stars. The bottom spectrum (id=896) is typical of a spiral galaxy with strong star formation and therefore has a very strong [OII] emission line. Black lines represent galaxy spectra. Green lines represent spectra noise multiplied by 4.
The Jørgensen team project is unique in the following ways: (1) large coverage of galaxy luminosities, (2) sufficient numbers of galaxies at each epoch to determine the slopes of the scaling relations like the Fundamental Plane (3) a large number of epochs (or redshift bins), and (4) consistent coverage in distance from the cluster at different epochs such that it is possible to differentiate between effects due to galaxy mass and due to cluster environment.
For more details, see the paper by I. Jørgensen, M. Bergmann, R. Davies, J. Barr, M. Takamiya & D. Crampton, “RXJ0152.7-1357: Stellar Populations in an X-Ray Luminous Galaxy Cluster at z = 0.83,” The Astronomical Journal, vol. 129, pp. 1249-1286, March 2005