. Their objectives remain the same – finding their children and demanding that Mexican authorities do more in guaranteeing the safety and protection of the estimated 323,000 Central American migrants that cross into Mexico each year.
Named in honor of “Doña Emeteria Martínez”, one of the founding mothers who passed away this year after reuniting in 2010 (after 20 years) with her missing daughter, the caravan is being accompanied and organized by various migrant rights organizations such as Movimiento Migrante Mesoamerican (MMM), human rights activists, and religious organizations.
Much of this year’s route focuses on the “Pacific route”: passing Guadalajara, Jalisco; part of the Gulf route, passing Tabasco and Veracruz; and crossing the central and southern states such as Chiapas and Oaxaca. Organizers are targeting foco rojo (flashpoint) zones where migrants riding the beast (freight train) are often kidnapped, murdered and extorted by organized crime or even corrupt migration and law enforcement officials.
Anita Celaya, a mother from El Salvador whose son disappeared 11 years ago crossing Mexico for the US, expressed in an event organized by the online magazine, Desinformémonos on December 9th, “It is incredibly difficult knowing everyday that your son is missing, but what is worse is when you come here to Mexico and see the conditions and the horrible things that migrants go through and endure.” She went on to say that “there is a fusion between the criminal gangs and the migration authorities…we don’t need to talk more about organized crime, but rather authorized crime.”
Along the route there are at least five re-encounters anticipated between the searching mothers and their missing children, along with cultural events, visits to migrant shelters, meetings with grassroots organizations in solidarity, and a potential meeting with Mexican lawmakers.
In a change from previous years, this year’s caravan was not granted full security or a police escort by Mexican authorities, rather partial security in some areas. However, the organizers and participants decided to carry on, understanding the risks.
“We have three main objectives: to find the missing, make visible the depth of the problem, and to denounce officials who have done little to protect migrants,” said Marta Sanchez, executive coordinator of the migrant rights group, Movimiento Migrante Mesoamericano, the main group organizing the caravan.
According to various independent accounts, more than 70,000 migrants have disappeared in Mexico since the beginning of the previous administration. Unfortunately, no official government account actually exists. All the existing official databases do not have the specific purpose of searching and documenting the disappeared. This is one of the reasons why the families of the disappeared and solidarity activists declare that the authorities have no will or intent in protecting migrants.
Sanchez also went on to say how authorities in the Central American countries, where a vast majority of the migrants are from, are also doing very little to protect the safety of their own citizens as they migrate northward. “There is no indignation on their part, their responses to the problem are far too minimal to its scale and depth,” she said.
Although the depth of the violence and scale of the forced disappearances is wide, Sanchez says the work and experiences of these caravans have produced substantial and concrete results. “When we started nine years ago we were alone,” she said. “Now more than a hundred organizations and countless individuals are helping us.”
The caravans have also produced concrete results regarding one of the primary goals: finding missing loved ones. “Over those past nine years we have found and reunited more than 200 people. We suspect that number to be higher since people often are able to get in contact with each other after seeing the media attention around our efforts, so we don’t have documentation,” added Sanchez.
Although members of the caravan have achieved receiving special humanitarian visas to search for their loved ones, there has been little gain in their objective to shift Mexico’s migration policy, which was presumably reformed specifically to help migrants two years ago.
In 2011 an immigration reform bill was passed, scrapping an outdated policy that made migration a crime in Mexico. The bill also reclassified the visa system, adding a new “visitor” status that former president Felipe Calderon (2006-2012) declared was a new addition for people such as migrants to have a legal stay in the country as they transited to the United States. However, when the president signed and enacted the bill, certain requirements were included to the “visitor” status that are nearly unobtainable to most migrants.
According to article 129 of the Migration Act, the applicant (of the visitors visa) must have sufficient funds to cover the amount of the costs of accommodation and meals during their stay in the national territory or have an invitation from an organization or a public institution or private establishment in national territory to engage in any activity in the country.
This requirement essentially makes it impossible for the majority of Central American migrants to obtain a visa and legally stay in Mexico, forcing them to continue to take clandestine, unsafe, and illegal means to travel through the country’s territory.
What the mothers on the caravan and migrant rights organizations are demanding is the addition of a “transitory” visa status to Mexico’s migration policy that would grant migrants with the intent to migrate to the United States, the possibility to travel through the country legally. However, recognized human and immigrant rights defender Bishop Raul Vera has expressed that the “migration law is controlled and won’t touch such a proposition, it is a joke where we haven’t seen any results.”
Finally, these mothers and their supporters are also trying to put a human face on this massive issue and to de-stigmatize the public perception of migrants.
“We want people to see that migrants are not criminals or narco-traffickers, but rather, sons and daughters with families that are desperately searching for them,” said Sanchez. “This has been one of the indirect achievements of these caravans.”