The Bag Lady: With plastic, you're playing a 'numbers game'
By Debbie Sandler
The Bag Lady
I am not really a New Year’s resolution maker. This year, however, the decision to change over to re-usable plastic water bottles coincided with the New Year. Back at the beginning of December I saw a
remarkable movie called, “Bag It”. One of the many valuable things I learned from this film was the actual “cost” of the single-use water bottles. Taking into account the fossil fuels and energy required to manufacture and transport plastic bottles to their destination it is estimated that the amount of crude oil used to make a SINGLE USE plastic bottle is one-quarter the volume of the bottle. That’s right, fill a plastic water bottle 25% with oil and that’s the amount of crude oil (a non-renewable natural resource!) it takes to make that bottle and get it to you! That was enough for me to decide that finding and using an alternative to single-use plastic bottles was something I could no longer put off. A friend of mine suggested that I pick up some BPA-free plastic water bottles and use those instead of the single-use water bottles that I purchased in cases at the grocery store. There has been a lot of attention surrounding the compound BPA, a chemical that has been used in the production of plastic water bottles (such as sports bottles), and is believed to be leached into the water over time. I had heard of BPA and wondered what the heck it was so I did what you don’t ever do unless you want way more information than you asked for…. I “googled” BPA. I will share with you what I have learned about this compound and I also want to discuss other plastic compounds as well.
Most single-use plastic water bottles have a resin identification code of 1. These codes are the numbers you find inside the chasing arrow symbol (triangle) on plastic products and are a set of symbols placed on plastics primarily for recycling separation purposes. You will find that beneath the triangle there is a set of letters which specifically identify the polymer (chemical structure) type and some are safer than others for food and liquid exposure. (See table of resin codes.)
The rule of thumb for basic safety for petroleum-based plastics is that the safer plastic recyclables display the numbers 1, 2, 4, and 5. Anything labeled with 3, 6, and 7, is not as safe and should be avoided or discarded specifically any baby food containers or bottles, sippy cups, or baby items.
To further avoid exposure to harmful chemicals used in plastics production, here are some suggestions:
- Use a paper towel instead of plastic wrap in the microwave.
- Don't microwave food in plastic containers (put food on a plate instead).
- Use dishware made from materials like glass or stainless steel.
- Avoid use of plastic containers with the number 3 or 7 on them.
- Plastics with the number 1 (typically used for water and soda bottles) are single-use only. Recycle after use.
- Do not drink water from a single-use plastic bottle that has been sitting in a hot car.
- It is also recommended that we avoid containers with the number 6 on them since these are polystyrene (Styrofoam) and have been known to leach carcinogenic styrene.
- Use tempered glass baby bottles instead of plastic. If you use plastic bottles, don't heat them.
- Store food in glass containers, rather than plastic.
- Discard scratched or worn plastic containers.
- Hand wash plastics to reduce wear and tear.
To make plastics hard or soft, chemicals such as Bisphenol-A, more commonly abbreviated as BPA, and phthalates (THAL-ates) are added during manufacturing. Scientists have overwhelming evidence that these and other chemicals are affecting humans – specifically babies in utero and children. BPA and phthalates are linked to numerous health problems – cancer, diabetes, autism, attention deficit disorder, obesity, thyroid function, infertility and even genital formation. Although bisphenol A came to fame as a potential poison in our water bottles, significant exposure comes from the linings of canned foods as well. It is safe to say that plastics that are marked with recycle codes 1, 2, 4, 5 and 6 are very unlikely to contain BPA. Some, but not all, plastics that are marked with recycle codes 3 or 7 may be made with BPA and it is best to avoid these when possible.
(As an unrelated addendum to the above, I discovered something of additional value while doing research for this article. Our ten year old cockatiel, a perfectly healthy bird, died suddenly and pre-maturely about a month ago. I happened to read that when cooking with Teflon or any non-stick pan at high temperatures you should avoid doing so if there is a bird in the room. Please be aware that emissions from this type of pan are deadly to birds.)
The amount of migration - the movement of free toxins from plastic into the substances they contact — (in this case it’s your food and water) and corresponding toxicological effects are highly disputed topics. It appears that there is no “best plastic” to contain food or drink. I hope that this article will clarify this viewpoint. By the time you’ve finished reading, my goal is that you should be closer to forming your own evaluation of plastics or at the very least, have a starting point for further inquiry.
Newsletter Signup
-
-
-