Reviewed by Harriet
“Janet Todd has combed the archives, explored all the possible options, and made connections based on probabilities in such a way that a credible picture emerges of the life and personality of this fascinating, talented woman.”
‘Aphra Behn was a woman who wore masks’. So says Janet Todd at the beginning of this monumental, newly revised biography of Behn, who was a prolific dramatist, poet, novelist and translator, and ‘the first
English woman to earn her living solely by her pen’. Born sometime between 1637 and 1643, Behn never spoke or wrote of her childhood and upbringing. Much of her adult life, too, though a little better documented, is shrouded in mystery. Janet Todd has combed the archives, explored all the possible options, and made connections based on probabilities in such a way that a credible picture emerges of the life and personality of this fascinating, talented woman.
Behn was probably born in Kent, to a lower middle class family. Nothing is known of her education or upbringing, or indeed of her marriage, which doesn’t seem to have lasted very long for whatever reason. In her 1688 novella Oroonoko: or, The Royal Slave, she depicts herself as travelling as young woman to the colony of Surinam, where she met the captured African on whom the story is based. There’s no evidence at all that this story is true, but one of the facts that is definitely known is that Behn was recruited as a political spy in 1666 and spent some time in the Netherlands on behalf of King Charles II. It’s therefore possible that if she did go to Surinam, it was as a spy.
In any case, spying in Holland turned out to be less than remunerative for Behn: she had to pawn her jewellery to survive, was forced to borrow money to return to England, and then spent a year petitioning the King for payment, which she may never have received. You’d expect that this would make her an anti-royalist but she was far from that – she was a tremendous admirer of Charles II and indeed of his brother, the generally unpopular Catholic James II.
In any case, the whole Dutch experience obviously made her realise she needed another way of supporting herself, and, having already published some poetry, she now turned to the primary focus of her career, that of writing plays. The theatre, banned under the Puritans, was enjoying a huge wave of popularity in the Restoration period, and Behn became an extremely productive playwright. She also wrote novels, including the fascinating Love Letters Between a Nobleman and His Sister (1684-7), a number of short stories, and a couple of collections of poetry. She did translations and adaptations, and collaborated with other writers on various works in all genres. Her health deteriorated badly in the last few years of her life, and she died in 1689.
Behn’s reputation has varied tremendously over the years, and indeed did so even in her own day. Although some of her works were extremely popular, she was considered by many as being a bawdy author, something that, though acceptable for a man, was not so for a woman. However, the women dramatists of the next generation paid tribute to her for making it possible to succeed in a career that was previously open only to men. But her reputation declined considerably in the eighteenth century, when Restoration frankness came to seem crude and immoral. By the nineteenth century, she was more or less forgotten, or if not, decried as coarse and indecent. Virginia Woolf was really breaking new ground when she wrote in A Room of One’s Own (1929) that:
“All women together ought to let flowers fall on the tomb of Aphra Behn….For it was she who earned them the right to speak their minds”.
Today, though, her work is much studied in universities, and Oroonoko, in particular, is seen as a text ahead of its time in promoting radical views of class, race and gender. Todd argues, however, that some of these views have been imposed on the work by contemporary theorists, as Behn was far from a progressive or liberal thinker in quite the way that postcolonialist or feminist theorists would like. She seems to have had little time or respect for the lower classes, nor to have had a problem with slavery, though she clearly responded to the idea of the noble savage.
There’s no doubt that Todd has done a fine job in filling in the context of Behn’s life and the wider social and political background of the period. Her close analysis of the work – plays, novels and poems – is also impressive. Although Behn seems to have liked a drink and the company of hard-living, rakeish friends, her life doesn’t appear to have been a particularly happy one. Apart from her short-lived marriage, the one relatively enduring love affair that can be more or less confirmed was with the bisexual Jack Hoyle, who may have kept her as his mistress for a period, but who seems to have had problems in consummating the relationship. This at least Todd deduces from the frequent appearance in Behn’s poetry of male impotence, especially in the case of strong, demanding women. There’s also a suggestion that Behn was not averse to relations with other women; her poem ‘To the Fair Clarinda, Who made love to me, Imagin’d more than woman’ may be read in that light, and often has been. But of course we really have no idea what she was up to most of the time. What does seem clear is that her final years were spent in poverty and increasing ill-health – a sad end for a woman who succeeded remarkably well in supporting herself through her own efforts in a male dominated world.
Janet Todd, Aphra Behn: A Secret Life (Fentum Press, 2017). 978-19095720652, 586pp., paperback original.
BUY Aphra Behn: A Secret Life from the Book Depository.