Using Data Compression in .NET 2.0by Wei-Meng Lee
09/12/2006
One of the new APIs available in the .NET Framework 2.0 is the new set of compression classes located in the
System.IO.Compression namespace. The two new classes in this namespace are
GZipStream and
DeflateStream. Using these compression classes, you can enable compression and decompression in your .NET applications using the well-known GZip and Deflate algorithms.
One of the compelling applications of data compression is to reduce the size of data transmitted over the network. This is especially important when the cost of bandwidth is a major concern. Consider the case of a web service returning the content of a database table via a dataset. The content of a dataset is transmitted as XML when exposed as a web service. When consumed by a client connected through an expensive medium (such as GPRS), every byte of data exchanged is billable. And hence, to make it less expensive for clients to consume these types of web services, it makes sense to compress the data on the server end and decompress it when it is received on the client side.
In this article, I will show you how to use the compression classes in .NET 2.0 in a web service environment. You will see the benefits of using compression in your application so that you can decide if you want to use it for your own applications.
Building the Sample Applications
Using Visual Studio 2005, let's first build a web service. Name the project C:\DatasetWS. In the Service.vb file, import the following namespaces:
Imports System.Data Imports System.Data.SqlClient Imports System.Diagnostics Imports System.IO Imports System.IO.Compression Imports System.Text.Encoding
Next, define the
getRecords() web method so that it returns the
Employees table from the Northwind database as a dataset (exposed in a byte array).
Note: This example uses SQL Server 2005 Express edition with the Northwind sample database. Since SQL Server 2005 Express does not come with any sample databases, you need to install the sample databases yourself. You can install the pubs and Northwind sample databases by downloading their installation scripts. Once the scripts are installed on your system, go to the Visual Studio 2005 command prompt (Start -> Programs -> Microsoft Visual Studio 2005 -> Visual Studio Tools -> Visual Studio 2005 Command Prompt) and change to the directory containing your installation scripts. Type in the following to install the pubs and Northwind databases:
C:\SQL Server 2000 Sample Databases>sqlcmd -S .\SQLEXPRESS -i instpubs.sql C:\SQL Server 2000 Sample Databases>sqlcmd -S .\SQLEXPRESS -i instnwnd.sql  Return ASCII.GetBytes(dsXML) End Function
Note that instead of returning the dataset as a
Dataset object, I have chosen to return it as a byte array. This is to allow us to add compression easily later on.
That's all you need for the web service. To test the web service, simply press
F5 and note the URL for the web service. You should see something like this:
The
11496 is a random port number that Visual Studio 2005 uses to launch my web service. You should have a different number on your computer.
Let's now add a Windows application project to the solution. Go to File -> New -> "Project..." and add a new Windows Application project to the current solution. Name the project C:\DatasetWSConsumer.
Populate the default Form1 with the following controls (see Figure 1):
- DataGridView
- Label
- Button
Figure 1. Populating the default Form1
Add a web reference to the web service created earlier. Name the web reference "dataWS" (see Figure 2). Click Add Reference.
Figure 2. Adding a web reference to the web service
Switch to the code-behind of Form1 and import the following namespaces:
Imports System.IO Imports System.IO.Compression Imports System.Text.Encoding
Double-click on the Load button to switch to its event handler. Code the following: '---time the download--- sw1.Start() '---connect to the web service--- Dim dsBytes As Byte() = ws.getRecords Label1.Text = "Size of download: " & dsBytes.Length '---convert the byte array into string and ' then read it into the dataset obj--- ds.ReadXml(New IO.StringReader(ASCII.GetString(dsBytes))) sw1.Stop() Label2.Text = "Time spent: " & sw1.ElapsedMilliseconds & "ms" '---bind it to the DataGridView control--- DataGridView1.DataSource = ds DataGridView1.DataMember = "Employees_table" End Sub
Essentially, this connects to the web service to fetch the dataset and then binds it to the DataGridView control. Press
F5 to test the application. After clicking the Load button, the DataGridView control will be populated. Figure 3 shows the output.
Figure 3. Binding the dataset to the DataGridView control
The first time you click the Load button, you will notice that it took a while for the DataGridView control to be loaded. Subsequently, the loading will be much faster as the data from the database is cached on the web service end. Observe the size of the data downloaded and the time taken for the download. You should click the Load button a few times so that you can obtain the average time required to download the data. In this case, it took about 65ms (on average) to download 266KB.
