The issue of paid leave is heating up in 2016. At least two presidential candidates — Democrat Hillary Clinton and Republican Sen. Marco Rubio (Fla.) — have proposed new federal policies. Several states and large cities have begun providing paid leave to workers when they are ill or have to care for a newborn child or other family member.
This forward movement on paid-leave policy makes sense. The United States is the only advanced country without a paid-leave policy. While some private and public employers already provide paid leave to their workers, the workers least likely to get paid leave are low-wage and low-income workers who need it most. They also cannot afford to take unpaid leave, which the federal government mandates for larger companies.
Paid leave is good for the health and development of children; it supports work, enabling employees to remain attached to the labor force when they must take leave; and it can lower costly worker turnover for employers. Given the economic and social benefits it provides and given that the private market will not generate as much as needed, public policies should ensure that such leave is available to all.
But it is important to do so efficiently, so as not to burden employers with high costs that could lead them to substantially lower wages or create fewer jobs.
States and cities that require employers to provide paid sick days mandate just a small number, usually three to seven days. Family or temporary disability leaves that must be longer are usually financed through small increases in payroll taxes paid by workers and employers, rather than by employer mandates or general revenue.
Policy choices could limit costs while expanding benefits. For instance, states should limit eligibility to workers with experience, such as a year, and it might make sense to increase the benefit with years of accrued service to encourage labor force attachment. Some states provide four to six weeks of family leave, though somewhat larger amounts of time may be warranted, especially for the care of newborns, where three months seems reasonable.
Paid leave need not mean full replacement of existing wages. Replacing two-thirds of weekly earnings up to a set limit is reasonable. The caps and partial wage replacement give workers some incentive to limit their use of paid leave without imposing large financial burdens on those who need it most.
While many states and localities have made sensible choices in these areas, some have not. For instance, the D.C. Council has proposed paid-leave legislation for all but federal workers that violates virtually all of these rules. It would require up to 16 weeks of temporary disability leave and up to 16 weeks of paid family leave; almost all workers would be eligible for coverage, without major experience requirements; and the proposed law would require 100 percent replacement of wages up to $1,000 per week, and 50 percent coverage up to $3,000. It would be financed through a progressive payroll tax on employers only, which would increase to 1 percent for higher-paid employees.
Our analysis suggests that this level of leave would be badly underfunded by the proposed tax, perhaps by as much as two-thirds. Economists believe that payroll taxes on employers are mostly paid through lower worker wages, so the higher taxes needed to fully fund such generous leave would burden workers. The costly policy might cause employers to discriminate against women.
The disruptions and burdens of such lengthy leaves could cause employers to hire fewer workers or shift operations elsewhere over time. This is particularly true here, considering that the D.C. Council already has imposed costly burdens on employers, such as high minimum wages (rising to $11.50 per hour this year), paid sick leave (although smaller amounts than now proposed) and restrictions on screening candidates. The minimum wage in Arlington is $7.25 with no other mandates. Employers will be tempted to move operations across the river or to replace workers with technology wherever possible.
Cities, states and the federal government should provide paid sick and family leave for all workers. But it can and should be done in a fiscally responsible manner that does not place undue burdens on the workers themselves or on their employers.
Editor’s note: this piece originally appeared in The Washington Post.
Related Books