Harmless Lung Cancer? High Incidences Of 'Indolent Tumors' Challenge Current Screening Protocols
Even in the absence of therapy, lung cancer may not be a death sentence. In a new review from Duke University, researchers show that nearly one in five lung tumors detected with computerized tomography (CT) imaging are slow-growing and unlikely to cause any real damage. Though the discovery may have little effect on current treatment protocols, it may represent new hope for the 228,000 Americans who receive the difficult diagnosis each year.
Published in the journal JAMA Internal Medicine, the review examined data from the National Lung Cancer Screening Trial — a National Cancer Institute (NCI) 6-year research effort involving 53,452 people at high risk for lung cancer. The team found that of the 1,089 subjects who received a lung cancer diagnosis, almost 200 had so-called indolent tumors. Unlike false positives that later turn out to be something else, indolent tumors are true malignant tumors — however, the growth is too sluggish to cause damage or induce metastasis.
“In addition to detecting aggressive tumors, screening will also detect indolent tumors that otherwise may not cause clinical symptoms,” the researchers wrote. “These overdiagnosis [sic] cases represent an important potential harm of screening because they incur additional cost, anxiety, and morbidity associated with cancer treatment.”
The discovery thus problematizes current screening protocols, as it suggests that many diagnoses established with CT scans cause more problems than they solve. To avoid unnecessary expenses and treatments, oncologists and patients must begin to familiarize themselves with the idea of “harmless” cancers. “People have to understand that we’re going to find some cancers which if we’d never looked, we never would have had to treat,” lead author Frank Patz said, adding that “it’s not something that is commonly known with lung cancer.”
That said, an endeavor to revamp protocols may ultimately founder on the overwhelming complexity of the diagnostic element itself. Like pancreatic and colorectal cancers, lung cancers typically fly under the radar until serious symptoms develop. For this reason, CT scans are often the only way to spot a tumor in its early stages.
Instead, experts argue that the results illuminate the need to step up the current inquiry into reliable biomarkers of pulmonary tumor growth. For example, researchers at the Cleveland Clinic recently identified a set of chemical signatures that could soon be used to develop a cancer breath test. By focusing on this type of research, the medical community could soon secure new diagnostic tools capable of differentiating between indolent and pernicious tumors.
Source: Patz EF, Jr, Pinsky P, Gatsonis C, et al. Overdiagnosis in Low-Dose Computed Tomography Screening for Lung Cancer. JAMA Intern Med. 2013.