Accelerating the Connected Future:
Here’s something you might not expect to hear from the head of a fiber organization: I’m really excited for 5G wireless networks. The US is already home to some of the best wireless networks in the world. These have driven untold innovations in devices and applications, which have improved our lives and added billions to our GDP. Experts, however, agree: our networks will not be able to meet requirements for new applications and devices coming up in the next few years.
The future of our wireless networks depends on the future of our wireline networks. Specifically, the projected performance and readiness of 5G wireless depends on the availability of fiber. Fiber has not traditionally been the first thing to come to mind when people think about wireless, but it should be. Meeting performance goals touted for 5G networks — high capacity, low latency, and extreme reliability — depends on having lots of fiber in lots of places.
Driving 5G With the Internet of Things
Until recently, people used the Internet to connect with each other, conduct brief transactions, and get information. Now, we connect physical objects to the Internet and to each other through small, embedded sensors. The ecosystem this creates, the Internet of Things (IoT), is one of ubiquitous, distributed computing, where “smart” devices securely collect and transmit data to other devices automatically and in real time.
The Internet of Things, which has industrial, consumer and civic uses, will drive economic growth and further change the way we live, work, and run our cities. These technologies will be critical for our economy: Consumer Technology Association projections show that in 2016 alone, IoT applications will help drive 30% of the consumer technology industry’s overall $287 billion in retail revenues. This does not include industrial, commercial, and city-level applications.
The IoT needs a better network: one that is unified rather than disconnected, capable of delivering high data rates and providing low latency, and covering broader areas. That’s the promise of 5G networks:
• Up to 1,000 times increase in bandwidth over 4G networks.
• Up to 100 times more connected devices.
• Up to 10 Gbps connection rates to mobile devices in the field.
• No greater than 1 millisecond of latency, something nearly indistinguishable to the human video watcher.
The promise of 5G is great — and indeed essential to the widespread adoption of IoT technologies — but so are the challenges to network deployment. 2G and 3G wireless networks often used copper-based backhaul to connect cell sites. While these networks have served consumers well, carriers and network operators all over the country are converting these legacy systems over to fiber. Why? Because fiber is a future-proof technology, capable of supporting higher capacities and the low latencies that our 5G networks will need.
Areas targeted for 5G coverage require lots of fiber to be successful, not just for capacity reasons, but also to meet the other performance goals related to network diversity, availability, and coverage, since all 3 of these goals are achieved through a greater number of interconnected paths of fiber. As wireless networks grow, through small cells and macro cells, fiber will continue to be the first-choice technology as the building blocks.
Seeing It in the Market
You don’t have to take my word for it — you can see this in some of the movement, mergers, and acquisitions in the industry. Windstream recently finalized its purchase of EarthLink, gaining 29,000 route miles of fiber. Analysts believe that 5G and network densification are at the heart of moves like this.
In their evaluation of CenturyLink’s recent purchase of Level 3, Barclays analysts noted that .” This transaction gives CenturyLink an additional 200,000 route miles of fiber.
The list of fiber acquisitions continues to grow. Crown Castle announced a potential purchase of FPL FiberNet, and Verizon is in the process of acquiring XO Communications.
How to Help 5G — and Fiber?
Unlike the current 4G technology, 5G requires a denser network of towers and radios to handle the traffic. Which in turn means: more fiber, to more places, faster. This makes the economics of deployment — and the wait for consumers — daunting. There are, however, things all levels of government can do right now to make deploying fiber easier and faster.
Time, as they say, is money. Efficient access to poles, ducts, and conduit, at fair prices has a direct impact on how quickly and cost effectively providers can deploy fiber. The Federal Communications Commission (FCC) has sought to revise its policies to ensure timely access to these critical network inputs, but I often hear from service-provider member companies who still encounter substantial problems when seeking access to these assets, particularly utility poles.
All too often, utility pole owners disregard FCC surveying timelines and attempt to impose conditions on using the poles, such as fixing pre-existing pole violations from attachments already on the poles. Congress could help by codifying these timelines, making sure that fair and reasonable cost-based nondiscriminatory charges apply, and giving the FCC the clear authority to impose fines when the requirements are not followed.
Implementing “dig once” policies is another way to help speed up fiber deployment. Installing an oversized conduit bank within the right-of-way to accommodate future users just once means that there will on procedural grounds in the last Congress. In this new Congress, we are hopeful that a similar bill could be reintroduced and quickly passed in order to benefit the industry and the quality of life for impacted communities.
These forward-leaning policies also extend to local governments who oversee deployment of broadband through zoning, permitting and other regulations. It is critical that governments protect the public interest while embracing policies and processes that reduce delays and costs — something that is also critical accelerating the deployment of fiber-to-the-home and fiber-to-the-business.
What’s Next?
Our association has a long history of supporting the rapidly-evolving ways we connect. We’ve been there from the beginning. We started out over 15 years ago as a group of forward-looking companies in an industry just in its infancy. Companies, and consumers, were just starting to get the hang of the Internet and figuring out what it could do for them. Our members were laying fiber, with speeds and capacity that were previously unknown.
We still believe in fiber-to-the-home as the best broadband access technology for consumers, but we are expanding our focus, including, for example, bringing fiber-to-the-business and fiber-to-cellular-sites. Our new name, the Fiber Broadband Association, brings us to where industry has evolved — including 5G networks. We cannot wait to be part of what’s next.