In
the late Victorian era, plaster casts of outstanding
classical, ancient, and medieval works were mass-produced
by various vendors. Just a few museums, like Carnegie
Museum of Art, went to extraordinary lengths to develop
their own large, unique casts. The West Portal of Saint-Gilles-du-Gard,
paid for by Andrew Carnegie on the recommendation of
art experts, is one of a kind, and is arguably the
largest architectural cast ever made.
Since making molds
directly from architecture could damage the originals,
then-Director of the Museum of
Art John Beatty faced problems in getting permission
for large, unique casts. In the case of Saint Gilles,
a gift of 2,000 gold francs to the town of Gard bought
permission—the thank-you note from the mayor
is in the museum’s archive. It took three different
shiploads from France to bring the 195 packing cases
with the Saint Gilles facade to New York, and a series
of flatcars to bring it to the Shadyside Station.
The
west portal cast is 38-feet high, 87-feet 3-inches
wide, and the molds were destroyed when removing
the plaster replicas. The plaster (with a binder
of horse
hair) has been tinted reddish brown, following
the good advice of the plaster makers, giving the facade
a warm, antique appearance.
Postcards of Saint Gilles feature the symbol of
the
wounded deer.
For generations the facade of Saint Gilles has inspired
Pittsburghers, especially young artists who make illustrations
of its details. The dominant presence in the hall,
it is especially popular during the holiday season,
and it has always served as a remarkable setting for
public activities.
Why Saint Gilles?
The West Portal of the Benedictine Abbey of Saint-Gilles-du-Gard
is considered by many to be the most beautiful of
all the great Romanesque portals and the culminating
example of the Provencal Romanesque in southern France.
This region, so close to Italy, soon showed the influence
of Christian Rome in church architecture, and the
façade of Saint Gilles is noted for having
an early sculptural treatment of the Passion of Christ.
The abby still exists and is a tourist attraction
today.
The west portal was constructed during more
than a century of craftsmanship in the 12th century,
as medieval
artists in the southern province of Languedoc exercised
their creative fancies in stone carving. They drew
upon images from Roman and Biblical tradition to
express the story of Christ on a church devoted to
a saintly
recluse, Saint Gilles.
Saint Gilles (c. 650-710 AD)
was a hermit priest who lived in the forest near
the Gard River, a tributary
of the Rhone where it empties into the Mediterranean.
Born in Greece (legend has it he came from a
noble Athenian family), during his youth he crossed
the
sea
to Rome where he became a priest. As a missionary
he wandered to southern France, where his reputation
for
humility and holiness drew so many admirers that
he eventually retreated to become a hermit into
the deep
woods, where his sole companion was a female
deer (hind).
Saint Giles and the Hind, c. 1500. by the
Master of Saint Giles. [The French Gilles is spelled “Giles” in
Great Britain].
The details of Saint Gilles life vary with the telling,
but certain elements remain common. The story
tells of how the king’s hunters struck a lily-white
hind with an arrow, and tracked the deer to its refuge
in a cave. In the cave lived the saintly hermit,
who protected the animal. Incensed at the cruelty
of the
king’s hunters to a helpless animal, Saint
Gilles reproved the king. The king, touched by
the behavior
of the humble, white-haired old man, became contrite.
He promised to build a holy place at the site,
and later revisited the Saint several times.
The reclusive
Saint Gilles took disciples, saw the construction
of a church begin, and placed it under the rule
of St.
Benedict.
The cult of Saint Gilles spread rapidly
and far through Europe in the Middle Ages, as witnessed
by some 19
places that bear his name in France, Germany, Poland,
Hungary, and the British Isles. During the crusades
in the 11th and 12th centuries, the Abbey of Saint-Gilles-du-Gard
was a refuge for pilgrims and crusaders on their
way to the Holy Land through the ports of southern
France.
For religious pilgrims and the illiterate
masses, the story of Christ was seen and explained
through
visual
sculptures and carvings on the façade of
the church. The west portal of the church signified
arrival
for the pilgrim, who then proceeded inside (and
east, in the direction of the Holy Land) towards
the ultimate
goal, the reliquary shrine at the east end. There,
pilgrims would kneel before the saint’s shrine
and touch or kiss it to be in closest proximity
to Saint Gilles.
During the religious wars of the 16th
century, the French Huguenots (Protestants) used
the church as
a citadel, ordered it razed, and left it in ruins.
The
broken faces of the religious sculptures are testimony
of this violent time. In the 17th and 18th centuries
there were efforts to rebuild the rest of the church,
but they were only partially successful.
Still, the
west portal survived as a luxurious example of
the early Romanesque style. It was this fame that
recommended it to the art experts that Andrew Carnegie
assembled in 1907. They fulfilled their task: to
identify the greatest sculptures and architectural
pieces from
antiquity to be displayed for the public in the
new, vast (and at the time largely empty) Carnegie
Museum
of Art in Pittsburgh.
Back to Contents