Let’s Talk About Race: 14 Atlantans on how far we’ve come—and how far we still have to go
Racism isn’t always going to look like racism
In November 2016, three weeks after the presidential election, our family of five deplaned at Hartsfield-Jackson International Airport after a quick trip to New York City. I made my way to the restroom closest to our gate with my eight-year-old daughter. Blessedly, the line was short. As each stall emptied, we scooted forward, dragging our roller-bag behind us. When it was our turn, the door from the wheelchair accessible stall swung open.
“Hang on,” I told my daughter, catching hold of her arm.
I turned to the other seven or eight people in line. “Does anyone need to use this particular stall?”
Suddenly, a booming voice ricocheted off the walls.
What do you think you’re doing? Who do you think you are? This is ridiculous! You’re wasting my time!
The voice belonged to a petite white woman with wide-rimmed glasses, barely 10 feet away from us. The veins in her neck bulged. Each enunciation ejected spittle. Her body quaked. I wondered if she would burst into flames.
“I’m offering the stall to someone who has a disability,” I replied.
Emboldened, perhaps, by my attempt to confront her with logic and calm, she continued ripping into us. Get the hell out! Just get the hell out of here! Never once did she say what we’d done to offend her so. The other women in line pursed their lips and shook their heads. None of them said a word.
I darted into the stall with my daughter and shut the door. I looked at her. Her lower lip was quivering. She seemed about to cry. She asked me why the woman was yelling at us. “She’s just having a bad day, sweetie, that’s all,” I said. But even as the words came out of my mouth, I knew they weren’t true. I knew that this woman’s eruption was racially motivated.
“We live in a time when evil people are no longer ashamed of being evil.”
In the months preceding the election just weeks earlier, Donald Trump had unabashedly scapegoated brown and black undocumented immigrants, Muslims, and Mexicans, awakening America’s flagrant racial hatred from its temporary hibernation. As disquieting as I found this woman’s fury, it was also familiar. It echoed what I routinely endured for years—during and after the Persian Gulf War, the Iraq War, 9/11. Aside from more obvious forms of racism (slurs like “sandni**er” and “dot-head”), strangers have confronted me in parking lots as I exited my car—“Where do you think you’re going? Are you sure you want to come here?” Sales clerks have followed me around department stores. At restaurants, servers repeatedly visited tables with white patrons, refusing to come take my order, even after my attempts to summon them. More recently, a white man mowing his lawn in a quiet suburban neighborhood yelled, “We don’t want you here!”
When we got home from the airport, I turned to Facebook, describing in detail what had happened. “Be aware,” I concluded, “that racism isn’t always going to look like racism. Sometimes it will look like this.”
In the post’s comments, a few of my white, Clinton-voting friends acknowledged they were not convinced that the woman’s diatribe was racially motivated: She might have been tired. She probably really had to use the bathroom. Maybe you misunderstood her.
This verbal attack failed to meet their standards for bigotry because it lacked certain racial markers: a Confederate flag T-shirt, a slur, a swastika tattoo, a red baseball hat emblazoned with “Make America Great Again.” For some white people, racism is a souvenir shop of brutality and propaganda. It embodies barbaric, cartoonish activity and brazenly parades through town.
But that standard is outdated, ignorant, and dangerous. It’s deeply rooted in privilege. White people in America have never feared for their lives because of the color of their skin and, as a result, have the luxury of excusing another white person’s hostility as someone having a tough day. Too often, there’s little effort in trying to understand a person of color’s context or history with racism. This is why white friends who knew me well enough to know I don’t distort truths could nevertheless rally behind a complete stranger by giving her the benefit of the doubt. It’s also likely why the other women in line—all of whom were white—who watched the event as it unfolded, failed to defend me and my daughter, or stand between the white woman and us. For them, this angry woman was extremely rude, nothing more. She posed no threat.
When it comes to identifying or defining racism and xenophobia, white people need to do less talking and more listening. What is and what is not racist must be determined by the people of color who are its targets. They are the experts, in the same way that members of the LGBTQ community are the experts on transphobia and homophobia, or Muslims are the experts on Islamophobia. All marginalized voices must be believed, centered, and supported. Any attempt to minimize, gaslight, or erase them only magnifies the trauma and compounds the pain and shame. It leads to silence, isolation, and strengthens oppressive systems of power.
Truthfully, the woman in the airport, and people like her, have never kept me up at night. But white, supposedly progressive, friends who deny my truth and doubt my instincts do.
Eventually, I got around to telling my daughter the real reason that woman was so mean to us. “Some people get very angry at people who have our skin color,” I said. “They are wrong, and it’s best to try to avoid them as much as possible.” As I fumbled around for the words, I could almost see her mind drawing the connections between our harrowing experience, Trump’s vitriolic speeches, and the threats of deportation recently made to a few of our loved ones. Even at her young age, she already grasps the idea that hate comes in myriad forms and unleashes itself without warning or provocation. She understands that we live in a time when evil people are no longer ashamed of being evil.
Believe me when I tell you. She knows.
Anjali Enjeti is an essayist and board member for the National Book Critics Circle.