Whether you're new to the workforce, or you've been a part of it for a while, you might find that you're sitting at a desk much of the time.
Or maybe you're only at a desk on certain days and for limited periods of time, but find you're sitting for long periods of time outside of work. In fact, our world today is designed so that we're on our rumps much of the time—from eating to driving to playing on the computer to working. Then we go to sleep and repeat it all again the next day.
This type of lifestyle—one of sitting and being sedentary for periods of more than an hour or two at a time—has a detrimental impact on our health and well-being. Unfortunately, there are dangers of sitting for long periods of time. But luckily, there are some office exercises and other initiatives you can take to combat it.
Your body needs to get up and regularly move to regenerate and stay stimulated.
Knowing how challenging life can be with health concerns, I'm all about promoting overall health and well-being, especially considering that a healthy life and happy life are typically not mutually exclusive. When I find out about possibilities to improve my health or heal my body, I do my research, and then give it a whirl if it feels right.
That's why I took it to heart when I was living in Maui and friend and fitness guru, Izaak Tyrrell, shared his thoughts on the "Chair Born Society," a term he coined as the title of his future book. Izaak shared, “The more lethargic and sedentary you are, the more your body begins to decompose and prepare for death. Your body needs to get up and regularly move with some form of progression so it can regenerate and stay stimulated. For every hour you are sitting, it's imperative you get up, walk around, and fully stretch out the body for at least 5 to 10 minutes.“
It might not be a surprise to some that sitting at your desk for long periods of time can cause a myriad of health issues, from fatigue to obesity to pain. For me, however, it was the extent to which it could be an issue that somewhat surprised me—it can literally take years off of your life.
Regular exercise does not counter the negative impact of sitting for long periods of time.
After Izaak first introduced me to the "Chair Born Society" in 2011, I began to see studies continually emerge to support his theory.
For example, a post on CNN, "Sitting for hours can shave years off your life," reported that studies conducted by the American College of Sports Medicine, the Centers for Disease Control, and the American Cancer Society all show similar results. The American Cancer Society study found that "women who sit for more than six hours a day were about 40 percent more likely to die during the course of the study than those who sat fewer than three hours per day. Men were about 20 percent more likely to die." The American Journal of Epidemiology published a study finding that "those who work a sedentary job have almost twice the risk of a specific type of colon cancer."
Even if you are active and exercise, these same studies, as well as a 2015 study by Annals of Internal Medicine, indicate that it does not compensate or equally counteract the damage done from sitting for long periods of time. This was a surprise to me. I would sit for long periods of time as a writer, getting caught up in the news or a good story; and in my early corporate days, I was practically attached to my desk and computer. But I thought I was OK because I was active and regularly exercised. Now that I know to be mindful of it, I do feel better the more breaks I take during the day. Another added benefit is the fact that I'm more efficient and productive when I take mini-breaks to refresh my mind and body every hour or two.
Take initiative to support your health and well-being.
To support your health while at work and beyond, consider the following tips and ideas to avoid sitting for long periods of time.
Get up every hour or two. This is the easiest and most obvious step you can take. Set your clock if you need to, and get up every hour or two and do something that requires standing. Take short walks around the block, up and down the stairs, or make a loop around the hallway office. Stretching is also a great choice. Get creative and find things to get you standing and moving that are easy to incorporate into your daily routine.
Request an adjustable desk. In some work environments, you might be able to request a desk that adjusts so you can alternate between standing and sitting. If you have a request from a doctor for such a desk, it could help. Further, if you do have health issues where having an adjustable desk would help minimize any difficulty in doing your work, then it might be considered a reasonable accommodation per the Americans with Disabilities Act and your employer will need to accommodate you.
Consider scheduling hiking or walking meetings. After understanding the effects of sitting for long periods of time, Author and Director Nilofer Merchant, began scheduling some of her meetings as walking meetings. This might or might not be an option for you, but you can always ask if it's a possibility, and hey, you can use this post as a reference! You can read more about Nilofer's approach to walking meetings in her post on Huffington Post: "Sitting is the Smoking of Our Generation."
Exercise during the day. If it's an option for you, consider doing part of your exercise regimen during the day, like lifting weights at the gym or walking on the treadmill. It's true that it might be a bit more inconvenient and require you to shower in the middle of your workday, but it could still be worth it to support your health by breaking up the length of time that you're sitting.
Exercise. Period. If you can't exercise during the day, then be sure you're exercising regularly throughout the week to maintain your health. Make exercise something you enjoy doing, too, like dancing, hiking, aerobics, walking your dog, or whatever might make you look forward to burning some calories and toning up the body. It doesn't have to be all grit and grime. It might not completely counteract long periods of sitting on you rump, but it does help improve health in general.
As reported in the same CNN post mentioned earlier, Mayo Clinic endocrinologist and researcher in Rochester, Minnesota, Dr. James Levine, points out in an issue of the journal Diabetes ."
Your health is more important than any paycheck. Without it, you might not have a paycheck at all. So please, be mindful of the length of time you're sedentary and sitting, no matter what you're doing, to support your overall health and longevity. Doing so can mean a long and healthy career for years to come.
Need help with your resume? Take advantage of our free critique today!