IT disaster recovery strategies: DR planning trends for 2010
Learn about the predicted DR trends for 2010, including outsourcing, server virtualization, desktop virtualization, unified communication and standards compliance.
Throughout 2009, many aspects of IT were impacted by the slow economy, and cost-efficient IT grew in popularity. With shrinking IT budgets and staff cuts, disaster recovery (DR) planning was pushed to the back burner, and many companies focused only on essential and ROI projects. This article outlines some of the DR trends for the IT industry for the next year, and how you can plan the most effective disaster recovery<<
2010.
Disaster recovery outsourcing.
A Forrester Research Inc. survey published in May 2009 shows that from 2006 to 2007, the number of firms that considered outsourcing their data center facility grew from 22% to 44%, and it was predicted that would continue to grow. While outsourcing is mostly driven by capacity shortages and the need to offset capital expenditure associated with building a new data center, resiliency was listed as the third most important item behind capacity and efficiency when comparing building versus outsourcing a data center. So this year, outsourcing data centers may be a popular option, especially for cash-strapped organizations that see outsourcing as a way to offset the cost of building a new facility while increasing resiliency and recoverability.
Cloud computing and disaster recovery strategies
A relatively new IT architecture choice, cloud computing, is rising in popularity as a disaster recovery strategy component. Cloud computing is seen by many companies as a way to ensure the resiliency of critical applications such as CRM, email and document sharing. According to Gartner Inc. at their most recent Data Center Summit, "by 2014, 15% of large enterprises will use a combination of private infrastructure and public cloud services in order to improve recovery and continuity readiness." So in 2010, expect to see more companies leveraging cloud computing as a way to offset the need to put in place and carry the cost of a DR infrastructure for critical applications. And depending on the early rate of adoption, expect cloud services to follow the demand.
Server virtualization
Server virtualization, while not a new technology, may see more use in 2010. Tools such as VMware's Site Recovery Manager (SRM) offer automation that further enhance the already widely accepted server virtualization and system instance mobility (HA and VMotion). Other tools such as Vizioncore's vRanger Pro offer what is called P2VDR capability, which has the ability to convert a physical server to a virtual instance for disaster recovery purposes. Ultimately, the upcoming trend is the predictability and automation of DR made possible by virtualization.
Besides VMware, other vendors and products such as EMC Corp.'s Acadia and NetApp's Dynamic Data Center are leveraging virtualization at the foundation for IT infrastructures with cloud computing as the driving force. While this is not exclusive to DR, it is definitely an effort to take virtualization to a new level. And throughout the next year, expect to see more IT organizations leveraging this maturing technology to further automate their disaster recovery capabilities.
Desktop virtualization
Desktop virtualization is similar to server virtualization, but focuses on providing access to a familiar desktop environment allowing end users to access applications remotely. The recent pandemic planning efforts driven by the H1N1 flu outbreak have raised the profile of this technology as a valuable tool for workforce continuity planning, which provides companies with remote access to users during a disaster. Workforce continuity planning is expected to become part of many DR strategies in this upcoming year. Citrix and VMware View are examples of technologies that already encompass these strategies.
Unified communication.
Standards compliance
The U.S. Department of Homeland Security (DHS) has been busy developing the "Voluntary Private Sector Preparedness Accreditation and Certification Program" (also known as PS-Prep). The main objective of the program is to encourage private sector companies to prepare for disasters. DHS has recently announced that three standards were identified for adoption to support this effort; the standards were developed by the National Fire Protection Association (NFPA), the British Standards Institution (BSI) and the ASIS International. While it is too early to predict how U.S. companies will react, the desire by DHS to adopt a standard may eventually be viewed as a competitive advantage, and even a trend by some companies. In any event, this is something worth keeping an eye on in 2010.
Although these predictions are not set in stone, it's likely that these technologies and strategies will take off in the upcoming year. With outsourcing strategies, virtualization technologies, more communication and certifications, no disaster recovery plan should be left sitting on the back burner in 2010.
About this author: Pierre Dorion is the data center practice director and a senior consultant with Long View Systems Inc. in Phoenix, Ariz., specializing in the areas of business continuity and DR planning services and corporate data protection.
Pro+
Features
Enjoy the benefits of Pro+ membership, learn more and join.
E-Handbook
Kickstart your IT disaster recovery plan
E-Zine
Moving target: Endpoint backup