Transport geography can be better understood from a series of eight core principles:
- Transportation is the spatial linking of a derived demand. It takes place because of other economic activities for which it is linking its spatial components as flows of people, goods, and information. For instance, commuting is the spatial linking of labor flows resulting from the demand for labor at one location (e.g. a commercial district) and its supply at another (e.g. a residential district). A market economy could not function without the capacity of transportation to link supply and demand, allowing for the transaction to literally “take place”.
- Distance is a relative concept involving space (how much is accessible), time (the duration of transportation), and effort (the cost or energy expense). How distance is perceived is a function of the amount of effort made to overcome it, which is commonly expressed as transport costs. A longer physical distance traveled with ease (e.g, low cost or short amount of time) implies less distance than a shorter physical distance subject to delays, congestion, and high costs.
- Space is at the same time the generator, support, and a constraint for mobility. It is the formal context in which mobility takes place, so space can be a support for mobility as it will shape the nature and structure of the transport system. Spatial differences in attributes such as resources, employment, and population act as generators and attractors of movements. How space acts as a constraint for transport is often relative and paradoxical. For instance, oceans and rivers act as a constraint for land transport systems such as roads and railways but can support maritime transportation. While the atmosphere is the physical support for air transport operations (air corridors), the weather can be a constraining factor under specific circumstances (e.g. snowstorms, thunderstorms, hurricanes). Further, transportation is a space by itself, an activity space, implying that during the transportation process, either in modes or at terminals, socioeconomic activities are taking place.
- The relation between space and time can converge or diverge. Every form of transport involves the consumption of a unit of time in exchange for a given amount of space (this is how speed is measured). Over time this process has mostly converged, implying that a greater amount of space can be reached with the same amount of time (or the same amount of space can be reached with a lesser amount of time). This is jointly the outcome of technological improvements as well as a better capacity and extent of transport infrastructures. The relation between space and time can also diverge when congestion starts to be significant and that each additional unit in movement results in an increase in delays.
- A location can be a central or an intermediate element of mobility. Locations are central when they act as generators (origins) or attractors (destinations) of movements. Locations are labeled as intermediate when movements are passing (transiting) through on their way to other locations. Ports and airports are often intermediate locations since they act as gateways or hubs within their complex transport networks.
- To overcome geography, transportation must consume space. Transportation infrastructures are important consumers of space, which includes the right of way (e.g. roads and rail lines) as well as the terminals. Jointly they form transportation networks. The more extensive a transport system and the higher the mobility level, the more extensive its consumption of space. For instance, in highly motorized cities, roads and parking spaces can consume up to 50% of the land. Globalization has been linked with the setting of massive terminal facilities such as container ports, airports, and distribution centers. While space consumed by road infrastructure is mostly linked with local and regional activities, the space consumed by rail, port, and airport terminals is linked with activities taking place at a larger scale.
- Transportation seeks massification but is constrained by atomization. Transport systems are the most effective when they develop economies of scale, particularly in terms of the loads (passengers or freight) they can carry. Massification involves conveyances with higher capacity and supported by larger terminals. However, the first and last segments of a transport sequence may require atomization, which implies that transport loads (passengers or freight) must be consolidated and deconsolidated. For instance, passengers taking a flight must consolidated into a planeload at an airport terminal and deconsolidated at the airport of destination. So, the higher the level of massification, the more complex atomization becomes. Although public transit can technically be more cost-efficient, many prefer individual (atomized) modes of transportation such as the automobile because of its point-to-point capabilities.
- Velocity is a modal, intermodal, and managerial effort. Velocity does not necessarily mean speed, but the time it takes for a passenger or a unit of freight to move across a transport chain. For instance, the speed advantage of air transportation is undermined if a passenger is spending several hours between connecting flights. Therefore, the velocity of passengers or freight is a joint consideration of the effectiveness of the respective modes involved and the intermodal operations connecting the modes. Also, the complexity of transport systems requires effective management of its operations, such as scheduling and settling transactions (e.g. fares). All of the above jointly contribute to improving the velocity of flows carried by transport systems. Recent efforts at the digitalization of transportation aim to increase the velocity of transportation through better management of existing assets and by creating exchange platforms between providers and users of transportation services.