1864: The forgotten war that shaped modern Europe by Tom Buk-Swienty
The brief but bloody clash of arms between Denmark and Prussia which took place in 1864 has never been regarded as one of the major 19th century European wars, and I cannot recall having ever seen a single volume devoted to it so far. In this book, which forms the basis of a new TV drama series, Tom Buk-Swienty has done us a service in reminding us that it had a far greater political impact than we may have appreciated.
Its origins were commonplace enough, having its roots in a dispute between Germany and Denmark over the ownership of the duchy of Schleswig, which lay between the borders of both countries. A complex issue which could not be solved by simple negotiation, it escalated into an international crisis which several contemporary heads of state feared could become a major European war and have far-reaching repercussions on the balance of power throughout the continent. The recently appointed Prussian minister-president, Otto von Bismarck, knew that the result could make or break his career. (It is sometimes known as 'the first of Bismarck's wars'). If Britain and France succumbed to pressure and supported Denmark, Prussia would be defeated and plunged into a political crisis – and subsequent history might have been very different. Fortunately for Prussia, but sadly for her Scandinavian near-neighbour, the rest of Europe remained on the sidelines. Once armies were mobilised, the final result was rarely in doubt. Danish troops, greatly outnumbered, made a valiant attempt to hold out but were no match for the forces of Prussia and her German ally Austria.
Much of the description in this book of the military campaign and the siege of Dybbøl is based on original eyewitness accounts, including letters, diaries, contemporary reports, newspaper articles and memoirs. There are many heroic and yet also harrowing stories of the fates of soldiers involved in the fighting on both sides, not just the casualties and the burials in mass graves, but also the injured who were unfortunate enough to linger with fatal wounds for several days. Reading about the fate of these men and the sterling work performed by the doctors and surgeons is inevitably a grim business. Tales of a generation stuck in a stalemate situation on the western front during the First World War are familiar enough, so perhaps it comes as no surprise to learn that there were parallel episodes during similar conflicts which took place half a century earlier. The effect on the civilian population of Denmark, of houses destroyed and families wiped out, added to the misery of a defeated and demoralised nation.
It was inevitably a mercy that the war was not prolonged. Like the battles and sieges themselves, the political consequences are well described in these pages. By the terms of the peace settlement in Vienna, the territory of Denmark was reduced at a stroke by one-third. Moreover, under Bismarck a victorious Prussia would provoke and wage two more wars within the next seven years. The result was to transform what had been a small German territory and enable it to take the lead in creating a new empire which thus became the most powerful territory on mainland Europe – with formidable consequences in 1914.
The book concludes with a useful chronology of the war, from the political crisis which had its origins in 1848 during the upheavals of the year of revolutions throughout Europe, to the final bombardments which precipitated the defeat from which there would be no way back for Denmark.
If there is a criticism to be made, it is that a straightforward chronological account would probably have served the reader better. It starts with accounts of episodes from the climax of the fighting, before going on to describe the political background and manoeuvres and the state of Denmark, which led to war. There is an endearing description of King Frederik VII, the popular, hard-drinking sovereign whose death in 1863, evidently after too many convivial evenings of drinking more punch than was good for him, precipitated the crisis. It comes however nearly halfway through – and after we have been given an account of the outbreak of hostilities.
Such minor issues apart, this is a good read of an often overlooked episode which had an incalculable impact on the subsequent history of Europe.
For a more biographical slant on the Prussian protagonists and royal family at the time who were personally involved, see also Letters To Vicky by Andrew Roberts (Editor).
You can read more book reviews or buy 1864: The forgotten war that shaped modern Europe by Tom Buk-Swienty at Amazon.co.uk
You can read more book reviews or buy 1864: The forgotten war that shaped modern Europe by Tom Buk-Swienty at Amazon.com.
Like to comment on this review?
Just send us an email and we'll put the best up on the site.