Sometimes I long for the good ol’ days when marketing and advertising seemed a lot simpler. There just weren’t that many choices—print, radio, TV, throw in a little direct mail, maybe some billboards, a reasonable ad spend, a clever campaign, and cross your fingers. As John Wanamaker, a successful merchant from the 1860s, so eloquently stated, “Half the money I spend on advertising is wasted, the trouble is I don’t know which half.”
Fast forward 150 years and the choices confronting marketers have swept over the advertising landscape like a digital Tsunami. With the myriad of digital advances has come an unprecedented ability to track results. That’s both the good news and, perhaps, the not-so-good news.
Run a PPC campaign and the proof is in the pudding. People either click and convert or they don’t. With an email campaign, you can track the results ad infinitum. Blog your way to success? Maybe, but is anyone actually reading? Do they care what you’re saying? Click and you shall see. Our ability to track and analyze is enough to give us all a marketing migraine.
One of the questions we get asked most often at Nomad is WHERE to spend HOW MANY of those precious marketing dollars. The HOW MANY is a topic for another time. The WHERE is where it gets interesting.
If you fall into the inbound-is-the-wave-of-the-future camp, then content, blogging, and calls to action are the tonic for all that ails you. Create fantastically rich and thought-provoking content, keyword it with long-tail keywords, offer insight in exchange for email addresses, and you’re off to the races.
This is largely the model pioneered and promulgated by my friends at Hubspot (full disclosure, I’m a Hubspot client). But even the Hubspotters have been spotted in the crowded corridors of PPC, using tried-and-true outbound tactics. Maybe it’s a function of success. Now a publicly traded company, maybe Hubspot needs more eyeballs and faster growth than inbound alone can provide. In other words, they’ve adopted a multichannel marketing approach.
So what’s a marketer to do?
Here are five multichannel steps to take to ensure a successful marketing strategy, regardless of which channels you use.
- Clearly define your target audience. Who are they? What are their key demographics? What do they read, watch, and listen to? What trade shows, if any, do they attend? What keeps them up at night? Develop critical customer profiles or, in inbound parlance, personas.
You can and should have multiple profiles for your current and prospective customers. While this might seem like Marketing 101, I can’t tell you the number of clients I speak to at both large and small companies that either haven’t developed customer personas or haven’t developed them well. How can you possibly know what your customers want if you don’t know your customers?
- Strategize your content. Sometimes, particularly if you’re selling a new product or offering a new service, you need to stir the pot to let people know you exist. Getting through the clutter is hard. Sure, we all dream of that viral video that launches us into the stratosphere, but the reality is that marketing takes time, patience, and persistence.
Depending on the size of your market, radio can be extremely effective at reaching a lot of people in a short amount of time, and it’s still relatively inexpensive. Just remember that, as with print advertising, repetition is key. Speaking of print, while experts claim to have heard the death knell for print, many people still rely on print as one of their trusted news sources—though the version they’re reading might be digital. Regional newspapers still offer a great reach at a fraction of the cost of larger national publications.
Similarly, web banners and PPC, if used judiciously, can yield fantastic results. This was the case for one of our clients, who during the course of two years, went from selling $20,000 worth of tickets online to selling more than $1,000,000 worth of tickets with an ROI of 20x.
- Social media. Let’s face it (no pun intended), Facebook advertising is still relatively cheap, and if you employ it well, it can yield huge dividends. For one client, we created a series of engaging videos targeted very specifically to key audiences and increased lead generation by more than 300 percent.
Social media is perhaps one of the most effective ways to post the content you’ve worked hard to create. LinkedIn, Twitter, and Facebook can be great places to let clients and potential clients know that you’re solving some of the problems that keep them up at night.
- Blogging and inbound marketing. Effective content can, if used correctly, help companies significantly increase their sale leads and conversions. Creating effective calls to action, providing your potential customers with useful and relevant content, and capturing their email and information can play a huge role in not only developing new clients and customers but also retaining and reinforcing your current client base. Remind them of the reasons they do business with you in the first place.
- Your website can’t suck. Just because you have a website doesn’t mean you can cross that item off the to-do list. Your current website must be a responsive design or Google will drop you like a bad habit. Sorry, we don’t make the rules. Make sure you are telling a clear, concise story and that your visitors are treated to an inspiring visual experience where clearly written text, instead of marketing gibberish, makes them want to click through your site. In short, speak human.