Florida Water Plant Cyberattack is Lesson in Cybersecurity for Critical Infrastructure
Oldsmar, a tranquil city of 15,000 people in the Tampa Bay area in Florida, unexpectedly became the victim of a cyber-attack in early February this year. Hackers gained remote access to the city’s water treatment plant and increased the amount of sodium hydroxide to 100 times its normal level.
This caustic substance is used in extremely low concentrations to control drinking water acidity and remove metals but is also the main ingredient in drain cleaner. “This is dangerous stuff…you’re basically talking about lye” said Oldsmar’s Sheriff, Bob Gualtieri at a news conference shortly after the incident. He added that the sodium hydroxide, had it actually entered the city’s water supply, could have made residents extremely sick indeed.
However, the attack was caught and mitigated long before this could happen, when the modified lye level was quickly noted by a supervisor. Oldsmar city officials underlined that other security measures would have prevented the contaminated water from actually arriving in residents’ homes, while the inexperienced hacker didn’t hide his presence and changed settings so dramatically that the modifications were easy to spot.
Critical Infrastructure Facilities Under Attack
Although this particular incident was resolved harmlessly, this is a scenario that cybersecurity experts have been warning about for some time. Most water and sewage plants, dams and gas and oil pipelines have moved to digital systems that allow employees to remotely track and adjust pressure, temperature and chemical inputs. The problem is that remote access creates a vulnerability that hackers can exploit, gaining control in order to potentially wreak havoc, and not all cyber-attacks are as innocuous as that of Oldsmar.
What was once the subject of science fiction has become a very real and constant threat as we move towards global digitalization, and critical infrastructure is becoming a more frequent target for hackers. Advanced Russian hackers have been regularly investigating American critical infrastructure systems since 2012, managing in 2017 to infiltrate one US power plant deeply enough to manipulate its controls before being caught.
In 2013 Iranian hackers were detected inside the Bowman Avenue Dam, a small structure that holds back a stream 30 miles north of New York. Had they been in control of the locks on the much larger Arthur R. Bowman dam in Oregon, as investigators originally feared, the attack could have resulted in disaster.
Human-Machine Interfaces
Yet we rarely hear about incidents of cyberattacks on infrastructure systems, despite the fact that power grids, water systems, sewage and manufacturing plants are usually monitored and controlled through “human-machine interfaces” or HMI — web pages designed for remote interaction, and notoriously easy to hack. If such incidents don’t make the news, it’s probably not because they don’t happen, but because there is no obligation for the victims to report them.
In the specific case of water treatment facilities, the US Water Infrastructure Act of 2018 does require water systems serving more than 3,300 people to carry out risk assessments and maintain emergency response plans but does not require them to actually report any cybersecurity breaches. Cybersecurity experts consider the smaller municipal systems to be the greatest cause for concern. With few resources they resort to remote access, creating the very point of vulnerability that can be exploited, but their small budgets mean they can’t afford much by way of cybersecurity protection, making them easy targets.
Transportation Systems are Affected
Transportation systems are also easy prey for cybercriminals, whose aim in recent US cybersecurity breaches has usually been financial gain through ransomware attacks — Colorado, San Francisco, Sacramento and Atlanta have all been victims in the last five years. Conversely the 2008 cyber hijack of a tram system in Poland injured dozens of people and clearly demonstrates the potentially serious danger in the future of our transportation systems.
A cyberattack in this sector could affect everything from traffic lights to high speed trains to airport radar systems, not to mention the self-driving cars of the future, with devastating consequences.
Although new cyber threats are being developed as fast as the technologies they intend to attack, and everything that is connected to a network should now be considered at potential risk, the cybersecurity market is also growing rapidly, with many innovative solutions available to help companies and organizations secure their digital infrastructure. With so much at risk as cyberattacks increase in volume and strength, it is essential to implement strong and effective defense strategies.
The Defense against Cyber Attacks
Legacy Technologies is a global leader in this field, continuously developing and supplying cutting-edge technologies for private corporations and public institutions to combat the rise of cyberattacks and cyberterrorism. This Israeli-German joint venture company is run by leading global experts on offensive and defensive cyber strategies, with decades of practical experience in military intelligence and international business.
NEO is Legacy Technologies’ best internationally-known cybersecurity solution, the result of seven years of development and rigorous testing against the large external infrastructures of major companies such as AT&T and PayPal and is routinely used by industry giants such as Mercedes, Tesla, and Starbucks. It is a fully-automated comprehensive service providing non-stop monitoring of cyber defenses, comparable to more than 100 white-hat hackers working together to identify security flaws and flag all breach points and vulnerabilities.
NEO undergoes continuous optimization, uses machine learning to identify otherwise unidentifiable security breaches and hidden assets, and can even spot human error. Comparable to an insurance policy against cybercrime, NEO is a long-term investment in ongoing security that exposes every weakness and develops appropriate and effective protections.
In addition to NEO, Legacy offers a complete suite of services, including cyber consultations, red teaming, penetration tests, asset management, software development and staff cyber training.
As public awareness about cybercrime has increased and cybersecurity solutions have evolved, the threats have as well, becoming ever more advanced. For this reason, it is more important than ever to implement equally advanced cybersecurity technologies and rely on the right partners to provide them. Legacy Technologies has the experience and the know-how to legitimately address the challenges of today’s fast-moving digitalized world, providing innovative and proven solutions for all cybersecurity requirements