The daily psychological stresses that police officers experience put them at significantly higher risks for a number of long-term physical and mental health effects, including obesity, cancer, sleeplessness and suicide, according to new research.
“This is one of the first police population-based studies to test the association between the stress of being a police officer and psychological and health outcomes,” said John Violanti, PhD, professor of social and preventive medicine in the University of Buffalo School of Public Health and Health Professions, and principal investigator on the study.
The five-year study of the Buffalo Police Department, called Buffalo Cardio-Metabolic Occupational Police Stress (BCOPS),,” said Violanti, a former New York State trooper.
The study found, for example, that shift work is a contributing factor in an increase in metabolic syndrome, which is a cluster of symptoms that includes abdominal obesity, hypertension, insulin resistance, type 2 diabetes and stroke.
Nearly half (46.9 percent) of the 464 officers in the study worked a non-day shift compared to just nine percent of U.S. workers.
“We found that, as a group, officers who work nights have a higher risk of metabolic syndrome than those who work day shifts,” said Violanti.
The study also found that:
- 40 percent of the officers were obese, compared with 32 percent of the general population;
- More than 25 percent of the officers had metabolic syndrome, a cluster of symptoms believed to increase the risk of heart disease, stroke and diabetes, versus 18.7 percent of the general population;
- Female officers experiencing the highest level of self-reported stress were four times more likely to have poor sleep quality, while male officers were six times more likely to have poor sleep quality;
- Officers were at increased risk of developing Hodgkin’s lymphoma and brain cancer after 30 years of service; and
- Suicide rates were more than eight times higher in working officers than they were in officers who had retired or left the police force.
“This finding challenges the common assumption that separated or retired officers are at increased risk for suicide,” said Violanti, noting, however, that the need for suicide prevention efforts remains important for both active and retired officers.
The study’s findings demonstrate that police work by itself can put officers at risk for adverse health outcomes, Violanti said.
“Usually, health disparities are defined by socioeconomic and ethnic factors, but here you have a health disparity caused by an occupation, highlighting the need to expand the definition of health disparity to include occupation as well,” he said.
Violanti adds that while police officers do have health insurance, the culture of police departments often goes against the goal of improving health.
“The police culture doesn’t look favorably on people who have problems,” he said. “Not only are you supposed to be superhuman if you’re an officer, but you fear asking for help.”
Police officers who reveal that they suffer from a chronic disease or health problem may lose financial status, professional reputation or both, he explains.
“If you have heart disease, you may not be allowed to go back on the street,” he said.  answer, according to the researcher, is to change the training of officers in the police academy so they understand signs of stress and how to get them treated.
“Police recruits need to receive inoculation training against stress,” said.”
The research was published in a special issue of the International Journal of Emergency Mental Health.
Source: University of Buffalo
Police officer photo by shutterstock.