What we haven't learned from the financial crisis
Saturday marks the 10th anniversary of the collapse of Lehman Bros., and it would be nice to report that Wall Street and Washington had learned the lessons of the Great Recession and put in place measures to prevent a recurrence.
Nice, yes. Accurate, no. In fact, little has been done to address the structural problems in markets that were so obvious during the bankruptcies, bailouts and bank runs of the last crisis. Even less has been done to anticipate the problems that will lead to the next crisis.
It’s not as if Congress, the Fed and successive presidential administrations didn’t see the problems. In the months after the Lehman collapse, all manner of reforms were considered. But after passing the relatively narrow Dodd-Frank Wall Street Reform and Consumer Protection Act in 2010, lawmakers considered the job done, and lobbyists began chipping away at the changes.
That lack of action ensures that the next crisis is a matter of when, not if.
To be sure, Dodd-Frank did take some important actions, most notably in requiring that banks maintain stronger balance sheets to protect them in the event of widespread loan defaults. But important parts of that law — including a section barring banks from making casino-like wagers on such things as interest rates and currencies — have been watered down in the ensuing years.
More ominous is the fact that significant areas of the financial system were not addressed in Dodd-Frank. And companion legislation to address these areas never materialized. Among areas of concern that were never addressed:
- Bond rating agencies. These firms, led by the likes of Moody’s and Standard & Poor's, gave sterling ratings to securitized bundles of toxic mortgages for the simple reason that they were paid by the issuers to do that. In the past 10 years, there has been much hand-wringing but precious little progress in eliminating the obvious conflicts of interest rife in the ratings game.
- Money market funds. These ultraconservative bond funds are still treated like bank deposits, which means that investors have every incentive to pull their money out if they hear that some of the fund’s bonds have defaulted. This happened in 2008 with a fund called the Reserve Primary Fund, prompting a 1930s-style bank run. This could well happen again.
- Government sponsored enterprises. Opinion is divided on the role that three unusual companies — Fannie Mae, Freddie Mac and Ginnie Mae — played in the Great Recession. But it is clear they pose a serious threat going forward. Thanks to their special connections to government, they can borrow money more cheaply than other companies, and have used this to dominate the business of guaranteeing mortgages against default. They are on the hook for three of five outstanding mortgages in America, a disturbing concentration of risk. Efforts to delink these companies from government to enable a broader and more diversified industry have gone nowhere.
Defenders of the financial status quo argue that regulation is not the answer. To some degree, they have a point. Even the relatively light regulation of banks included in Dodd-Frank has prompted a fair amount of gamesmanship. This is evident in how banks are slowly ceding much of the home loan origination business to nonbank institutions such as Quicken Loans.
Even so, given what the years 2007 through 2009 showed about how fragile financial markets can become during crises, it is amazing how little the nation has learned.
Join the Conversation
To find out more about Facebook commenting please read the Conversation Guidelines and FAQs
This conversation is moderated according to USA TODAY's community rules. Please read the rules before joining the discussion.