One of the most iconic endurance racing cars of all time — the Ford GT40 — came about because of a grudge between two titans of automotive industry. Sometimes business is personal after all.
The story starts in the early 1960s, when Henry Ford II, chief executive of U.S. automaker Ford, decided that it would be a smart branding move to get involved in auto racing. One quick way to build a reputation was to acquire an existing prestigious company with a reputation as a winner, and so Ford approached Italian auto maker Ferrari. The company's founder, Enzo Ferrari, proposed a deal in which Ford would buy a 90 percent interest of the Italian company for $18 million.
But at the last moment, Ferrari had a change of heart. As Preston Lerner recounts in his 2015 book "Ford GT: How Ford Silenced the Critics, Humbled Ferrari and Conquered Le Mans," the Italian auto mogul got second thoughts about becoming another cog in what he derided as "the enormous machine, the suffocating bureaucracy of the Ford Motor Company." He seized upon a clause in the contract which required Ford to approve major expenditures as a deal breaker.
Henry Ford II, a member of an esteemed American automotive clan, was taken aback by the rebuff. He reportedly told Don Frey, one of his lieutenants who had overseen the failed Ferrari bid: "You go to Le Mans, and beat his ass."
That was a tall order. The 24 Hours of Le Mans, an auto endurance race that dated back to 1923, was perhaps the most prestigious motorsport event on the planet, one in which cars drove around an 8.4-mile (13.6 kilometer) course near the French city of Le Mans over and over, with the aim of covering the most distance in a day's time. And from the late 1950s to the mid-'60s, Ferrari cars dominated the event, winning seven of eight races between 1958 and 1965.
To break that dominance, Ford would need a special car. Ford's chief engineer, Roy Lunn, came up with the concept of a two-seater sports car with a low-slung, shark-like body and a powerful V-8 engine located between the axles. The design was 156 inches long and 40 inches high, which led to it being dubbed the GT40. To speed up the development, Ford teamed up with British race car builder Eric Broadley and his company Lola to build the car. Learn more about the development in this CarStuff podcast:
Lerner, the auto historian, explains what made the car so innovative: "The Ford GT40 was one of the first prototype sports cars to fully take advantage of the benefits associated with a mid-engine design, most notably a slinky aerodynamic shape and benign handling characteristics," he says via email. "It also demonstrated that a large, but lowly stressed, engine originally designed to be used on street cars could succeed in endurance racing against the most exotic motors in the world."
Even with those innovations, the GT40 struggled in its initial races in 1964. That led Ford to turn over control of the racing program to Carroll Shelby, a former champion racecar driver turned designer, who had earned Enzo Ferrari's enmity by beating him at Le Mans in 1959 as a driver for Aston Martin.
In 1965, the Shelby-led Ford team at Le Mans, driving a new version of the GT40 called the Mark II, started out strong against Ferrari, only to have its cars forced out of the race by mechanical failures. It was a frustrating defeat, but in 1966, Ford fixed the bugs and came back with even better cars. This time, the GT40 Mark II not only beat Ferrari, but obliterated its storied dominance, taking first, second and third in the race.
The 1966 finish, this year celebrating its 50th anniversary, provoked some controversy. Ford decided to have two of its cars — one containing Bruce McLaren and Chris Amon, and the other with Ken Miles and Denis Hulme — cross the finish line together, to drive home the point that the GT40 itself, and not the drivers, was the reason for victory. But Miles' timing was slightly off as he backed off the gas pedal near the end, and McLaren's car ended up covering slightly more distance and was credited with the win.
Ford returned the following year with yet another version of the GT40, the Mark IV. To rub more salt in Ferrari's wounds, the Mark IV had been designed, engineered and built entirely in the U.S. Again, Ford bested the Italians.
Here's a 1967 newsreel about the race:
According to Lerner, the Ford GT40 helped establish the physical template for the racecars that would compete at Le Mans for decades to come. But it had an equally profound impact in terms of changing the culture of racing.
"This was one of the first times a mainstream manufacturer committed itself to a large effort on the international stage," he said. "The model it used was providing money and internal R&D resources while farming out the actual racing to professional race teams. A half-century later, this is the way things still generally work not only at Le Mans but in Formula 1, NASCAR and other forms of motorsport."
YouTube