The idea British women suddenly started working during the First World War is an absolute myth. Most working class women had always been part of the British workforce—mainly in textile manufacturing, farming, education and the service industries. With the commencement of war, an estimated two million women replaced men in the workplace leading to a considerable rise in the proportion of working women—from 24% in 1914 to 37% in 1918.. The greatest increase of women workers was in engineering. Over 700,000 of these women worked in the highly dangerous munitions industry. Industries that had previously excluded women now welcomed them. There was a particular demand for women to do heavy work such as unloading coal, stoking furnaces and building ships.
The war gave women greater opportunities—a wider range of occupations and an alternative to traditional roles—which led most notably to a decline in domestic service. From the 1700s to 1911, around 12% of the female population in England and Wales worked in domestic service as cooks, maids, nannies, cleaners, etc. This dropped to less than 8% by 1931—mainly due to job opportunities available for women in the workplace. Half of the women who applied to work at London omnibuses in 1916 came from domestic service. An interesting side effect of all this was the increase in labor saving devices—vacuum cleaners, automatic washing machines and domestic refrigerators.
The influx of women into the job market gave rise to trade unions. In 1914, 375,000 women were members of a trade union. This had risen to over one million by 1918. The only problem here was the fact women were still paid far less than their male counterparts for doing the same job….plus ca change…
More women in work meant more childcare services. Around 100 nurseries were established for women working in munition factories during the war. However, the government of the day did not provide similar services for women working in any other industries.
The Women’s Social and Political Union (WSPU)—the suffragette movement—which had campaigned for women’s suffrage was split by the war. Originally formed in 1903 by Christabel Pankhurst and her mother Emmeline Pankhurst, the WSPU divided between Christabel and Emmeline who supported the war and Sylvia Pankhurst who was against it. The WSPU was not in favor of universal women suffrage but rather suffrage for a small (upper) class section of the female population—”Votes for ladies” rather than “votes for women.”
The war led to changes in suffrage as those males allowed to vote had to be resident in the UK for twelve months prior to any election. As most of the electorate had been overseas fighting in France—this meant there was only a small percentage of men eligible to vote. The Representation of the People Act in 1918 gave votes to men over the age of 21 and all women over the age of 30 who were occupiers of property or married occupiers of property. This was in small part an acknowledgement of the essential work carried out by women during the war—but also in large part due to tireless political campaigning for the right to vote. For if the women’s right to vote had been inspired solely by their actions during the war then surely women under thirty would have also been given the vote. Most women who worked in munition factories or in essential war work were single, in their late teens and early twenties. These young women were actually pointedly denied the right to vote by the Representation of the People Act. Apparently the war effort—as some historians hold—did not really merit a “thank you” to the women who worked on the home front. That would take another ten years before women over the age of 21 had the right to vote, just like men.
As part of the propaganda for the war effort, photographers were sent out to document women at work in factories across Britain. These photographs of women laborers at the Parsons’ Works on Shields Road, Newcastle, were taken between 1914 and 1918, and are held by the Tyne and Wear Archives and Museums:.
These pictures are not stylized as later photographs were during the Second World War for far more overt propaganda purposes. These women are intensely focussed in getting on with their job. Some seem camera shy—but it must have seemed strange to be photographed at work when it was such an ordinary yet essential thing to be doing.
Via Tyne and Wear Archives and Museums