WorkerGlobalScope.console
console read-only property of the
WorkerGlobalScope interface returns a
Console object providing access to the browser console for the worker.
Syntax
var consoleObj = self.console;
Value
Example
This property allows you to have access to a browser console for debugging purposes, inside a worker. So for example you could call
console.log('test');
inside a worker (which would basically be the equivalent of
self.console.log('test');, as these are being called on the worker scope, which can be referenced with
WorkerGlobalScope.self), to return a test message out to the browser console.
If you are calling
console.log() from a
DedicatedWorkerGlobalScope or other worker scope that acts on a single loaded window, that tab's web console will receive the logs. However, If you are calling
console.log() from a
SharedWorkerGlobalScope, the global browser console will receive the logs.
Note: Firefox has a bug with using
console.log inside shared/service workers (see bug 1058644), which may return strange results, but this should be fixed soon.
Specifications
Not yet part of any specification.
Browser compatibility
See also
License
© 2016 Mozilla Contributors
Licensed under the Creative Commons Attribution-ShareAlike License v2.5 or later.