By in and studied interdisciplinarity and collaboration across a number of fields, through a number of topics, in a variety of ways and in relation to a range of problems. One field that has routinely confronted matters of interdisciplinarity and collaboration is computer supported co-operative work, which has turned these and other practices into research problems and topics of inquiry in their own right alongside other concerns and preoccupations.
In recent years sociologists (and social scientists in general) have been working alongside computer scientists in what has been assumed to be in increasing numbers, or at least greater regularity, than previously. This is explained in part by the explosion of interest in social media-as-data (Housley et al, 2014, Edwards et al, 2013) and a cross-disciplinary interest in the emerging contours of digital, networked and automated societies as a key aspect of social change and transformation at the beginning of the C21st. It is often assumed that an interdisciplinary approach is required, due to the need to scope and understand these changes and related phenomena through a range of methods, theories and data and in ways that synthesize a firmer grasp of current social and computational realities. Consequently, interdisciplinarity is conceived as an epistemological enterprise, but, as I will attempt to tentatively outline in this blog, it is also has ontological features and consequences.
Questions of interdisciplinarity within digital social research contexts have recently identified language as a key area through which collaboration can be hindered and the realization of interdisciplinary working between sociologists, say, and computer scientists impeded. Of course language, as a communicative practice, is key. As are the practical means through which theorization, methodological strategies and the collection and curation of data are accomplished; in ways that can answer jointly identified problems and questions e.g. whether social media data can be used to augment traditional social scientific methods for understanding public reaction to signal events? However, the tools and framework for interdisciplinary working require reflection and work by those who wish to participate. The problems and challenges associated with interdisciplinary collaboration are not merely those associated with translation and are therefore not reducible to a single fix. There is no interdisciplinary Babel Fish; and no single solution that stands outside a range of practices that are built through interaction in interdisciplinary settings and contexts.
For example, we might wish to consider the ways in which teams are organized, how the choice architecture of collaborative tools that we develop or use are shaped, how we foster the ability to take another disciplines ‘point of view’ and how we participate in and attend to the negotiation and accomplishment of both a shared perspective and our own disciplinary awareness at one and the same time.
A key issue here is the ways in which core disciplinary concerns and questions coalesce and shape how, for example, an interdisciplinary research group may approach a specific research problem. This is more than language and more akin to a requirement to spend some time immersing oneself or at least systematically reflecting on different disciplinary forms of life and the social life of paradigms. Whilst I am looking at a problem or phenomenon in terms of prosaic questions such as social organization my computer scientist friend maybe viewing these through the lens of information and dreams of automation.
A useful resource here can be found in Schön’s ideas surrounding ‘the reflective practitioner’ (1983). This was a popular trope in the late 1980’s and 1990’s for developing the knowledge capacity of key professional groups such as nurses, social workers, engineers, architects and teachers as they confronted new problems, institutional structures and the reorganization of working life around teams and inter-professional working and delivery. I re-introduce it now as it might be an effective starting point for thinking about how we might promote reflective engagement by participants within interdisciplinary contexts such as ‘digital social research’, ‘computational social science’ and related fields such as ‘social media analytics’; betwixt and between different academic groups and aligned ‘knowledge agents’ often collaborating and competing, working and fighting, in liminal, status poor spaces.
Schön (1991:269) in his discussion of reflective practice argues that variations between professions (as the modern ‘knowledge agent’ ideal type) can be contrasted with specific constants. He argues that these constants provide for a means of considering the variation of practice between different professions. Members of disciplinary cultures are readily socialised into patterned forms of knowledge, interpretation and practice. The academic tribes of ‘sociologists’, ‘computer scientists’ or ‘discourse analysts’ and ‘social statisticians’ are anthropologically consistent in this regard. Whilst wider institutional and socio-technical forces are revolutionising knowledge work in ways not anticipated twenty to thirty years ago, distinct ‘professional groups’ remain with new ones emerging on the horizon e.g. the data scientist.
According to Schön (1983:270) these constants or ‘patterns’ associated with knowledge groups and agents can be described in terms of the following:
- The media, languages, and repertoires that practitioners use to describe reality and conduct experiments
- The appreciative systems they bring to problem setting, to the
evaluation of inquiry, and to reflective conversation
- The overarching theories by which they make sense of phenomena
- The role frames within which they set their tasks and through which
they bound their institutional settings
Perhaps these four phenomenological constants could form a matrix through which we can begin to link reflection with a more mindful form of reflective practice within interdisciplinary research contexts. In terms of the case being considered, perhaps collaboration between computer scientists and sociologists (and other social scientists) might benefit from some form of systematic training for those embarking on cross-disciplinary engagement in the hope of charting new territory and understanding new things through innovative theoretical, methodological and data driven interdisciplinary strategies. At the very least it is worth thinking about as a means of informing the process through which we become practical interdisciplinarians.
References:
Edwards A, Housley W, Williams M, Sloan L, Williams M. Digital social research, social media and the sociological imagination: Surrogacy, augmentation and re-orientation. International Journal of Social Research Methodology. 2013 May 1;16(3):245-60.
Housley W, Procter R, Edwards A, Burnap P, Williams M, Sloan L, Rana O, Morgan J, Voss A, Greenhill A. Big and broad social data and the sociological imagination: A collaborative response. Big Data & Society. 2014 Jul 1;1(2):2053951714545135.
Schon D. The reflective practioner. Temple Smith, London. 1983.
Categories: Digital Sociology, Interdisciplinarity
Tags: digital social research, digital sociology, interdisciplinarity
Great piece – enjoyed it. I’m interested in how the interdisciplinary space might in fact be the “a-disciplinary” project space.