Torino 2005 Course
Contents
Gaze-Based Human-Computer Interaction
28-29 April 2005, Politecnico di Torino, Italy
Description
The tutorial provides examples, experiences and design guidelines for using eye gaze in human-computer interaction. The goal is to give deep insight into exploiting the information about gaze direction in human-computer interaction. The participants will learn the basics of eye-tracking, but the focus of the tutorial is on the interaction issues. After the tutorial, the participants should understand the pros and cons of using gaze as an input device in real time. Various aspects of gaze interaction are covered both theoretically and in practice using live demonstrations with a state-of-the-art eye-tracking device.
Eye gaze is not much used in human-computer interaction. However, the advances in eye-tracking technology make it an increasingly interesting option to be added to the conventional modalities. It is easy to understand that point of gaze indicates the focus of visual attention, which is a crucial element in building attentive, proactive interfaces -- but there are numerous pitfalls to be avoided. The instructors have used eye-trackers for a decade, both for command-and-control and for attentive interfaces. We will share our experiences and design guidelines that can help other developers to understand the reasons behind the problem issues and to design solutions that avoid the traps.
Audience
The tutorial does not assume previous knowledge on eye-tracking, since the basic concepts will be explained. It will be of interest to participants wishing to learn more about this modality, and to participants wishing to get ideas on how to apply it in interaction. Live demonstrations will ensure that the audience gets a concrete feeling of the interaction and the applications.
Outline of the Program
Thursday 28.4., 10.30-13.30 (3 hours):
Part I: Theory and Methods
- Introduction
- Live demonstration of an eye-controlled application
- Background
- Eye movements research
- Technological background
- Taxonomy of eye-tracking applications
- Gaze data visualization and analyzing methods
- Gaze points and fixations
- Visualizing cumulative data
- Studying real world tasks
- Data analysis
- Scan paths
- Fixation maps
- Abstracted image stylization
- Eye typing
- Issues and approaches
- Another demo
On Thursday evening: Get together party & pizza!
Friday 29.4., 10.30-13.30 (3 hours):
Part II: Applications
- Gaze-aware applications
- Eye typing continued
- More command-and-control applications
- Multimodal applications
- Gaze-contingent displays
- Attentive interfaces
- In-depth example: iDict, an attentive reading aid
- Basic idea
- Live demonstration of the application
- Proactivity
- Implementation challenges
- Design guidelines
Speakers
The instructors have experience with eye-tracking devices from the mid-1990's. Both are experienced educators. Kari-Jouko Räihä has been teaching courses for 25 years, also in the United States (Cornell University, University of Oregon). Päivi Majaranta has taught several courses at the University of Tampere on human-computer interaction and usability.
Kari-Jouko Räihä is Professor of Computer Science at the University of Tampere, Finland, where he leads the Tampere Unit for Computer-Human Interaction (TAUCHI). He holds a Ph.D. degree in computer science from the University of Helsinki, Finland. For the past fifteen years he has led research in human-computer interaction, covering algorithm animation, groupware systems, user-centered design, multimodal interaction, information visualization, spoken dialogue systems, and gaze-based interaction.
Prof. Räihä has published more than 50 refereed papers on his work, and participates regularly in program committees of major conferences in the field. He was co-chair of the program committee for NordiCHI 2004, and is co-chair of both ETRA 2006 and IDC 2006.
Päivi Majaranta is the scientific coordinator of the five-year European network of excellence on Communication by Gaze Interaction (COGAIN, 2004-2009). She obtained her M.Sc. in computer science in 1998 from the University of Tampere. Her research interests are computer-aided communication, multimodal interaction, and especially eye-aware and eye-operated computer interfaces. Currently, she is doing her Ph.D. research on an eye typing system.
Materials
The notes will include
- an introduction to the tutorial
- copies of all slides
- a full bibliography of all cited works
- selected readings
Sample slides
Preregistration for the course is required. The registration form is accessible through the web site of the course. Note that this is the final module of a longer course that starts on the previous week.
Mobility grants
Members of COGAIN can apply for a mobility grant to fund the participation in the course. Email office@cogain.org for more information.