Emergent Artificial Intelligence (AI) technology is finding both early adopter excitement and also resistance from critics.
Champions are pushing capabilities and adopting the technology to create efficiencies through Corporate Real Estate (CRES). AI is increasingly being adopted by CRES as it can significantly improve efficiencies – creating better, more comfortable work environments, saving organizations money and relieving CRES Teams from dull repetitive tasks to focus on higher value work.
However, dissenters remain justifiably sceptical. Data collection (what and why) and privacy/ storage are all issues which data creators (employees) are concerned about.
Storage and data security is a complex issue with many influencing variables (country/ region of data capture, sector and internal data policies) to be considered that can only be addressed on a case-by-case basis.
But, the reason for collecting data and what’s collected by CRES can be more universally addressed. Regardless of location and sector, AI is being adopted by CRES for the same fundamental reason – to create better and safer workplaces improving the user experience and delivering better CRES-side efficiencies.
The key to broad, successful AI acceptance is demonstrating to the user that data collection comes with significant benefit for them. The trade-off of allowing CRES to understand where employees are in facilities, employees get improved facilities. Education and communication can be improved outlining these benefits. The other element positively swaying attitudes towards AI is the language being used.
But, CRES is doing a poor job of communicating to building users and our customers how collecting data and using AI across day-to-day and longer term planning will improve their workplace experience.
Educating Employees on How CRES Uses AI and Why
As Artificial Intelligence quickly becomes ubiquitous through all technologies (smart buildings and autonomous vehicles to name a few) implementation comes with varying success levels. Mainstream media tends to highlight the failures over the successes – stoking fears. Common concerns surrounding AI include the elimination of many jobs.
But, we know that 20% of all building users feel that workplaces are not meeting their needs. This has a significant impact on how they feel when on-site and also on their productivity. Implementing AI-driven technology enables round-the-clock environmental monitoring allowing rapid resetting bringing the environment to the ideal temperature with the right light levels – a huge benefit to building users that is not being sufficiently communicated.
Looking to longer-term horizon and incorporating AI into strategic space planning, AI-equipped sensors monitor where employees go, collecting the data CRES relies on to identify usage trends throughout facilities. These people driven trends gives CRES a better understanding of what’s working in facilities. AI’s capabilities to collect and reliably analyze big data quickly enables this identification meaning CRES can continue replicating successes facility-wide while reducing the space types that employees clearly don’t like and don’t use.
In this era of hyper-data collection on and offline with people are being manipulated or scammed or their details are being leaking, CRES needs to be clear with employees what data is being collected from them in order to make facilities safe and more comfortable for them. And, fortunately, the answer, not much data. CRES is only interested in binarys – if a person is in a space or not. Sensors don’t monitor what’s being done or productivity levels as monitoring these activities is not CRES’ purpose. Most sensors don’t identify a person, which means that, at the point of collection the data is anonymized. The sensor simply records that a space has a person in it. Even though data collection is anonymous, it’s still important to let employees know they are part of facilities management now with their movements throughout a day contributing to strategies improving building performance. Being able to communicate this by outlining what data is collected and next steps is an easy way to change minds especially where the results are immediately apparent to users (i.e. buildings do become more comfortable and safer).
These employee-centric advantages have only been possible in the last few years thanks to AI driven technology. Communicating the experience improvement is part of the education required to win over reluctant and fearful employees. CRES is not using AI for nefarious reasons, instead to improve the user’s experience when on-site.
Re-orientating Language to Reflect Employee-centric Benefit
As Raj Krishnamurthy – CEO of Workplace Fabric – has noted ‘Workplace Occupancy Sensors’ can do much more than simply monitor occupancy – both from a sensor capability, but also when linked to a deeper, smart system that’s driven by AI to adjust environmental conditions based on occupancy – and does not do justice to what the technology is actually capable of. By changing the language, renaming the sensors to be ‘workplace availability sensors’, the benefit is reframed focussing the primary benefit to the employee. Now employees can easily understand which workplaces are available for them to go and work in.
Summary
Artificial Intelligence is a technology many are fearful of. And media, by and large, are happy to perpetuate these fears through clickbait worthy headlines.
This creates a challenge for CRES who are incorporating AI for its ability to support day-to-day building management and aggregate the data required to plan effective buildings for tomorrow. But, simply communicating what’s being done and why will help to tackle fears, especially where wins are quick to come to fruition and the benefit to employees is so apparent.