Dear all,
While reviewing the Microsoft Operations Framework (MOF) and Checklists for the daily use of monitoring health of SharePoint environments, I found the following interesting information about memory leak detection.
These for sure are among the worst things that can happen to a SharePoint administrator, since they can cause occasional downtimes and cryptic error messages.
As with almost any troubleshooting approach for SharePoint, you should go to the ULS logs and search for specific error messages. These are the two most common sources of memory leaks:
1. “An SPRequest object was not disposed before the end of this thread. To avoid wasting system resources, dispose of this object or its parent (such as a SPSite or SPWeb) as soon as you are done using it. This object will now be disposed”
Careful: Watch out for large numbers of this error message. It can be the case that such messages are “false positives”. Luckily, the ULS logs provide also object counts, so you can easily see whether this is occurring often or only a single event.
2. No specific error message, but:
Symptom: Intermittent application pool recycles.
Result: Downtime.
Problem: Hard to reproduce and debug for the administrator.
Explanation: Not properly disposed objects cause the garbage collector not to be able to recover used memory. As a result, the growth of memory by the application pool can increase greatly, causing a security protection mechanism to trigger an application pool recycle.
Solution for both problems: Dispose objects properly. Microsoft provides a guide on how to do this properly here:
Best Practices: Using Disposable Windows SharePoint Services Objects
Also, there is a very handy tool to detect memory leaks, which detects possible memory leaks in custom SharePoint solutions which do not comply with Microsoft’s best practices. You can find descriptions and the download of this tool here:
SharePoint Dispose Checker Tool
Happy and (safe) coding & stay tuned till the next time!
Best regards,
Mart?