For decades inventors have been trying to make guns that can be fired only by their owners, without sacrificing reliability. Stuffy industry types call them personalized weapons, but everyone else just calls them smart guns.
Most smart-gun prototypes so far have depended on biometrics (voice, palm, or fingerprint scans) to verify the owner, but none have made it to production. With the possibility of sweat or blood blocking a sensor, dependability remains a concern.
That's why German gun-maker Armatix took a different approach with its iP1 smart gun (above). The first production smart gun to be marketed in the United States, the $1,800 iP1 uses radio-frequency identification to safeguard the weapon: As soon as the gun loses radio contact with its accompanying wristwatch, it automatically deactivates.
The main purpose of smart guns is safety. Records kept by the Centers for Disease Control from 2013 (some of the most recent collated information) show 505 accidental gunshot deaths in the U.S. for that year. And according to Johns Hopkins University, unintentional shootings are among the most preventable forms of gun violence. Presumably, smart guns could also deter gun theft and even protect police officers who lose their gun in a tussle.
But finding support for smart guns in America isn't as easy as it would seem. First, there's the politics. The National Rifle Association is notoriously prickly when it comes to anyone intervening in the gun market, so even safety technology is viewed as a potential threat. In fact, the only store to carry the iP1 stopped selling it last year after receiving hate mail and an arson threat from gun-rights activists.
Part of the reason for these fears is one tactless law. In 2002 New Jersey passed the Childproof Handgun Law, mandating that gun sellers sell only personalized weapons in the state once there are smart-gun products for sale. This all-or-nothing approach has been polarizing, so now the same politicians who passed the law are discussing how to repeal it in favor of tax incentives that promote smart guns.
Aside from politics, there's also the much larger issue: Smart guns just might not make sense. The iP1, for example, accepts only .22 LR ammunition, which is fine for target shooting but is too low a caliber for most who prize self-defense. It's also $1,800—you could buy a trio of new .40-caliber Glocks for that.
Armatix says it's working on larger caliber versions of its pistols, and as with any new technology, prices tend to come down. But street credentials still matter, and that might come only from professionals. "The holy grail of smart guns is a large purchase order from a law-enforcement agency," says Stephen Teret, director of the Johns Hopkins Center for Law and the Public's Health.
If lawmen adopt a firearm, it means they feel it's reliable enough for real-world use. Then the industry will follow. This is how the Colt .45 Peacemaker dominated the market in 1830—by first selling to the Texas Rangers and then marketing to stagecoach riders. Until this happens, though, don't expect to see a smart gun at your local gun shop anytime soon.
HOW IT WORKS: ARMATIX IP1
Firing .22 LR bullets from a ten-round chamber, the iP1 relies on a linked rechargeable wrist-worn watch for activation. Communication between the watch and weapon are at radio frequencies that are resistant to interference.
The pistol has a blocking pin that will only move when it receives an authorization signal from the watch. At more than fifteen inches of separation between the two, the pin moves back into place and the gun won't fire.
The watch requires a personal identification number before the authorization signal is sent. If the PIN is correct, "good" appears on the display, which also shows charge levels for the gun and watch.