In Poland, where the practice of risk management is still a new discipline, the local risk management association believes it is realistic to encourage companies to jump straight into the gold-plated version: enterprise risk management.
At the Polish Association of Risk Management's first conference recently, ERM was a hot discussion topic for the country's risk managers and other risk experts.
A primary objective of PolRisk is to demonstrate that risk management is more than just buying insurance or managing financial risks, said Rafal Rudnicki, PolRisk's board president.
"We actually need to introduce the concept and benefits of ERM from scratch, here," said Mr. Rudnicki, group risk manager for the Poznan, Poland-based Raben Group.
Since the collapse of communism in Eastern Europe, Poland has been changing legally, economically and socially on a steep learning curve, Mr. Rudnicki said.
"Risk management is no exception (to) that. Our economy now, and our businesses are no different from those from Western Europe--we have similar challenges, and diversity of threats and risks, so we (again) cannot afford for a trial and test approach and repeating mistakes made already in the past by someone else," Mr. Rudnicki said. "I think this is not a matter of choice--we have to jump in on the top solutions, right now. It is about being competitive in Europe.
But there is a debate whether it is feasible to think that companies in the fast developing economies of central and Eastern Europe can largely bypass traditional practices and move right to ERM techniques.
As Pierre Sonigo, secretary general of the Federation of European Risk Management Associations in Brussels, Belgium, phrased it: Can companies "go from the Middle Ages to the 21st century?"
"Can you do a leap like that?" Mr. Sonigo, a former risk manager, asked in an interview at the PolRisk conference. "It doesn't seem too realistic to me, but, on the other hand, why not? Why not start immediately at the state-of-the-art and try to implement it?"
Some risk managers in Poland believe it is the preferable approach.
"We skipped the bank checks and we went directly to the electronic cards...so I think it will be similar with risk management," said Tomasz Miazek, risk insurance manager at Warsaw-based Telekomunikacja Polska S.A., Poland's largest telecommunications provider. "We will just skip normal risk management; we will go straight to enterprise risk management."
TP, a former state-owned company that is now part of France Telecom S.A., will implement ERM "in the very near future," he noted.
Anna Skalmierska-Wozniak, risk manager at Orbis Group, the largest hotel chain in Central Europe, said as long as risk managers have the support of their management board, "it is realistic for domestic companies to consider ERM." There are, in fact, a number of examples of companies in Poland that are in the process of implementing ERM, she said.
"Having (the) opportunity to learn from experienced partners, Polish companies have a chance to start from a very high level and to learn from others' mistakes," she said.
By some accounts, ERM hasn't taken hold in Western Europe like it has in the United States or United Kingdom.
This is because the way most companies are run in Western Europe--a silo-based corporate structure--tends to suit a traditional risk management approach, experts said.
"Now, whether Central and Eastern Europe can leapfrog that is a different matter," said Christopher Gore, chief executive officer of MAI Insurance Group in Budapest, Hungary, which runs an independent broker and insurance consultancy throughout the region.
To jump straight into enterprise risk management, "I think that it is one step too far," Mr. Gore said.
From his experience, those with the title of "risk manager" at about 90% of Central and Eastern European companies are actually insurance buyers or insurance managers. The other 10% are transforming themselves into insurance risk managers, rather than just insurance buyers, he said.
"Ultimately, there are some pretty dynamic and clever people here in Central and Eastern Europe, and I am sure that there are many companies that will adopt enterprise risk management over a period of time. But they've got to start with the traditional (risk management), and go through the hoops to get to the top," Mr. Gore said.
That's a view shared by the Bulgarian Risk Management Assn., based in Sofia.
"We have discussed the issue and are almost completely united in the opinion that since traditional risk management has long been neglected in our environment, the only feasible way is to start and make this thing right first," said Stoian Lilov, CEO of the Bulgarian association.
"It is very hard to get our boards to buy into sponsoring and accepting the deliverables of traditional risk management, let alone be on the forefront of the latest developments," he said.
Best foot forward
Certainly the members of PolRisk come from a different perspective. They want to expose company risk managers to ERM from the start.
That was the case at the PolRisk conference, which kicked off with an hour-long presentation on the topic by Stephen Roberts, senior vp in the risk consulting practice of Marsh Ltd., the London-based unit of New York-based Marsh Inc.
Mr. Roberts, in an interview, said it is realistic for companies with little traditional risk management experience to incorporate elements of ERM from the start.
They can begin with the creation of a so-called prioritized risk register, where risks are formally identified and analyzed. Also, they can increase awareness of risk management across the company by establishing a company risk management policy or risk management statement, he said.
"At this stage, there is a high interest across the region in enterprise risk management," Mr. Roberts said.
There is a "misperception," he said, that ERM is for a "large entity which has a one-size-fits-all aspect, which it is not. Enterprise risk management is a bespoke service to the client's own organizational structure, size and objectives."
Meanwhile, it is incorrect to assume that a silo management structure is an immediate barrier to ERM. "Often, enterprise risk management can be the vehicle used by organizations to try and close down those silos," Mr. Roberts said.