Back in 2016, we wrote about the importance of automation in taking applications from development to production with Payara Server. Since then, there have been a lot of changes both in Payara Server and Payara Micro and the wider tech landscape.
There were a few key goals of the original article, which can be summarised as:
- A "DevOps-style" approach to configuration
- Infrastructure-as-code
- Automation over manual changes
Now, in 2018, the same goals are still important and the same tools exist to solve problems and reach those goals. There are some other new tools available which can help solve some more problems for users who may have Docker as their target environment.
Here, we'll look at two ways to configure the Payara Platform for different environments, whether in or outside of Docker.
Config API
The Eclipse MicroProfile® project's first "home grown" specification was the Config API. Designed to be a solution to the problem of application configuration which may need to change depending on the environment where it's deployed. Without this API, the application may need to be modified and repackaged between deployments to different environments or, alternatively, a different version for each environment may need to be built.
There is a comprehensive example in the Payara-Examples repository which demonstrates different ways of using the Config API to read in configuration from various different sources. The API can be used programmatically or with CDI annotations, as shown below:
public class ProgrammaticConfigUsageSample { public void useTheConfig() { // get access to the Config instance Config config = ConfigProvider.getConfig(); String serverUrl = config.getValue("acme.myprj.some.url", String.class); callToServer(serverUrl); } }
public class CDIConfigUsageSample { @Inject @ConfigProperty(name="acme.myprj.some.url", defaultValue="") private String someUrl; public void useTheConfig() { callToServer(serverUrl); } }
In both samples, the same URL is being retrieved from a config source and used by the
callToServer() method.
There are many Config source options, each of which may be used simultaneously. These may include environment variables, system properties or any of the additional sources implemented by Payara Server or Payara Micro. To ensure that priority is preserved for these sources in a deterministic way, the order of priority is controlled with ordinals. Each config source has a default ordinal which can be overridden by the user. The higher the ordinal, the higher the priority. For Payara Server and Payara Micro, the
cluster config source is the highest ordinal at
160 which means that any property which is found in the Hazelcast data grid will be the preferred value.
Variables in Server Configuration
While the MicroProfile Config API can be very useful for dynamic app configuration, there are a lot of places where it is still useful to reference variables in server configuration which would not be covered.
Before we get to the options, though, it's important to think about why we might want to have a variable server configuration. Surely the best practice would be to make sure that the platform is well-known and consistent and keep the things that vary to the application? This is certainly still the case but, in a container-based environment, the value becomes more clear.
Docker containers are constructed with layers where the ideal best-practice scenario would be to keep the things which change most infrequently at the base. We may wish to define a company-wide base image with just an OS and then layer Java over the top for the part of the organisation which uses Java. For teams which use Payara Server or Payara Micro, the ability to specify variables in configuration suddenly becomes much more interesting.
To better explain, a worked example might look like the following (note that this example requires Payara Server 182)
FROM payara/server-full:182 ENV ASADMIN ${PAYARA_PATH}/bin/asadmin # WARNING: be careful with heap sizes. Invalid settings will stop the server from starting! ENV MAX_HEAP 512m ENV MIN_HEAP 512m # set heap sizes to depend on environment variables RUN ${ASADMIN} start-domain && \ ${ASADMIN} delete-jvm-options -Xmx512m && \ ${ASADMIN} create-jvm-options -Xmx\$\{ENV\=MAX_HEAP\}\$\{ENV\=MIN_HEAP\} && \ ${ASADMIN} list-jvm-options && \ ${ASADMIN} stop-domain && \ rm -rf ${PAYARA_PATH}/glassfish/domains/domain1/osgi-cache
With the above Dockerfile, we can build a standard image for our organisation with other modifications included - perhaps with JDBC drivers or RAR files added - but to keep the example simple, I have only added variables for the maximum and minimum heap sizes.
Note that I have given default values to these JVM options because if the environment variables don't exist, the server will fail to start. I've also purged the osgi-cache directory (generated on server start) to reduce the size of the image.
All we need to do now is build the image:
And now we can reference it in the FROM command in our new Dockerfile, so that we inherit the new configuration.
FROM myOrg/payara-configured:LATEST # We can specify our own environment variables to override the others ENV MAX_HEAP 2g ENV MIN_HEAP 2g
Here, our Dockerfile is very bare. We are only setting new values for environment variables to increase the heap sizes. This is because the official payara/server-full image sets an ENTRYPOINT which our other Dockerfiles inherit.
With this example, it's easy to see how Dockerfiles can be used to inherit sensible defaults and override configuration where necessary to create Docker image based microservices.
Both the MicroProfile Config API and the ability to use variables in configuration files give an enhanced ability to control environments declaratively and make some early steps towards a future DevOps (or even "GitOps") style approach where the entire infrastructure could be described and version controlled. To accomplish this ambitious goal, other tools would be needed - but the Payara Platform offers many of these abilities for the runtime today.
Questions about this post? Start a discussion at the Payara Forum