Scared space
De-engineering residential streets to make traffic safer
The folks down in Chatham are facing that dilemma so familiar to our migrant middle class families whose second homes consist of minivans or SUVs: As more and more young families with children move to the suburb looking for a safe place to raise their tax deductions, the streets become less and less safe for kids.
Residential streets used to be play spaces. Cars were few. Moms stayed at home — literally, as most families had only one car. Today such streets are crowded with mini-trucks driven by moms escorting their precious cargoes to and from, and in the process making the street dangerous for their neighbor’s kids.
All the usual remedies have been tried, or at least talked about, beginning with the erection of “Children at Play” signs and ending with urgent entreaties from concerned parents to install stop signs to slow traffic. The issue, explained one mom to a State Journal-Register reporter, is how to make vehicles slow down so “bikers and children and walkers [will] be able to enjoy the residential street and the quietness.”
Alas, drivers gradually learn to ignore warning signs, and stop signs seldom slow traffic except at the stop itself, since they excite impatient drivers to speed through the rest of the block to make up time. That is, when drivers stop at all; its police chief has listed drivers’ failure to stop completely at traffic signals among the most common causes of accidents in south Sangamon County’s garden spot.
More signs and more traffic controls are not the answer. The conventionally engineered street forces drivers to pay attention to the wrong things. Instead of watching and taking account of other road users (including pedestrians and cyclists) they are watching for (and being distracted by) flashing lights, pavement markings and signs. Reading a sign warning of children at play makes it easier to run into a child at play. (In the English city of Leicester, where sidewalks are narrower than most Americans and houses hug the road, they installed bollards painted to look like kids in school uniforms about to step into the roadway. No word yet on whether it’s working.)
The key to making side streets safer is to make drivers more attentive. Generally speaking, anything that makes a road appear narrower will compel drivers to slow down. Edge lines do this, as do painted bike lanes that have the same effect. In Chicago they paint parking lines to visually narrow roadways and reduce speeds. Such tricks are part of the local traffic codes in some English towns and in some U.S. cities.
If the illusion of danger induces more cautious driving, why not restore real danger to the experience? Cities in Europe have been experimenting for years with de-engineering residential streets by removing traffic lights and stop signs and erasing lane markings. The only rule in effect is, Don’t hit anyone.
The art is probably most advanced in the Netherlands, thanks to the advocacy of “shared space” concepts by Dutch engineer Hans Monderman. A roadway is not just a separate conduit for traffic but a part of the landscape that surrounds it. Walkers, joggers, cyclists and kids have equal access as motor vehicles. Instead of trusting the traffic engineer, drivers on shared streets must trust their eyes.
Driving on such a street is disorienting, since it is not obvious whether the car, bike or pedestrian has priority. But its confusing-ness is why it works, since it forces everyone to slow down. At 20 miles per hour drivers are able to see and establish eye contact with pedestrians and cyclists, and everyone has time to adjust their movements to avoid collisions, and those collisions that do occur do little damage.
Navigating along a shared street requires thinking as well as steering, and thinking about driving is something that most Americans dislike doing. We prefer to crash-proof our vehicles rather than our streets, with the result that drivers feel comfortable eating or chatting on the phone while they drive, thus making their vehicles more dangerous to the rest of us.
There are places in Illinois where streets work according to shared space principles, albeit by accident. Chicago and its inner suburbs, and a few places Downstate, relatively narrow residential local streets without driveways whose curbsides – once reserved for deliveries and the occasionally carriage – are today lined with parked cars on both sides. As a result, such streets often require drivers approaching from opposite directions to negotiate who goes through first. Speeds are slow because drivers are more alert to the dangers posed to themselves as well as the danger they pose others – a much more powerful incentive to prudent behavior. Call it scared space.
Contact James Krohe Jr. at peptobiz@mindspring.com.