SYNOPSISatdgen [options...] [atd-file]
DESCRIPTIONatdgen reads ATD type definitions and generates OCaml code (both ml and mli files) for
- ---
- type definitions (option -t)
- ---
- serializers and deserializers for Biniou (option -b)
- ---
- serializers and deserializers for JSON (option -j)
- ---
- record-creating functions supporting default fields (option -v)
- ---
- user-specified data validators (option -v)
If no mode option (-t, -b, -j or -v) is given, then -t -b is assumed. Unless -o is present, the <prefix> for the generated files is derived from the atd-file argument. If the atd-file argument is omitted, atdgen reads ATD sources from standard input, if additionally -o is missing, it behaves as if -o - was given.
OPTIONS
- -t
- Produce files <prefix>_t.mli and <prefix>_t.ml containing OCaml type definitions for the ATD input
- -b
- Produce files <prefix>_b.mli and <prefix>_b.ml containing OCaml serializers and deserializers for the Biniou data format
- -j
- produce files <prefix>_j.mli and <prefix>_j.ml containing OCaml serializers and deserializers for the JSON data format
- -v
- Produce files <prefix>_v.mli and <prefix>_v.ml containing OCaml functions for creating records and validators, see also option -validate.
- -dep
- Output dependencies in makefile-format for all possible atdgen output files and exit
- -list
- Output a space-separated list of all possible atdgen output files and exit
- -o <prefix>
- set the <prefix> for the options -t, -b and -j. If <prefix> is -, atdgen writes code in the form of
- struct ... end : sig ... end
to standard output.
- -biniou
- [deprecated] same as -t -b, i.e., produce serializers and deserializers for Biniou and OCaml type definitions (default)
- -json
- [deprecated] same as -t -j, i.e., produce serializers and deserializers for JSON and OCaml type definitions.
- -j-std
- standard JSON: Convert tuples and variants into standard JSON and refuse to print NaN and infinities. This option implies -json unless another mode is specified.
- -std-json
- [deprecated] same as -j-std
- -j-pp <func>
- Apply the OCaml function <func> of type (string -> string) to the input of each *_of_string function generated by atdgen (JSON mode). (This was intended for UTF-8 validation of the input which is not performed by atdgen.)
- -j-defaults
- Output JSON record fields even if their value is known to be the default.
- -j-strict-fields
- Call !Ag_util.Json.unknown_field_handler for every unknown JSON field found in the input instead of simply skipping them. The initial value of this reference prints a message and raises a Failure exception.
- -j-custom-fields <func>
- Call function <func> of type (string -> unit) for every unknown JSON field found in the input instead of simply skipping them. See also -j-strict-fields.
- -validate
- [deprecated] same as -t -v, Produce data validators from <ocaml validator="x"> annotations where x is a user-written validator to be applied on a specific node. This is typically used in conjunction with -extend because user-written validators depend on the type definitions.
- -extend MODULE
- Assume that all type definitions are provided by the specified module unless otherwise annotated. Type aliases are created for each type, e.g. type t = Module.t
- -open MODULE1,MODULE2,...
- List of modules to open (comma-separated or space-separated)
- -nfd
- Do not dump OCaml function definitions
- -ntd
- Do not dump OCaml type definitions
- -pos-fname FILENAME
- Source file name to use for error messages (default: input name)
- -pos-lnum LINENUM
- Source line number of the first line of the input (default: 1)
- -rec
- Keep OCaml type definitions mutually recursive
- -version
- print version and exit
- -help | --help
- Display this list of options
AUTHORThis manual page was written by Sylvain Le Gall <[email protected]> and Hendrik Tews <[email protected]>, specifically for the Debian project (and may be used by others).