For Melissa Whiting, teaching is about challenging students, encouraging them to take risks and preparing them for their post-academic lives.
Whiting, 57, professor of English and rhetoric at the University of Arkansas at Fort Smith, has taught at UAFS since 2004, but began her teaching career in 1978 at Sperry High School in Sperry, Okla. She also has taught at the University of Oklahoma and the University of Southern Mississippi. She has bachelor’s and master’s degrees from the University of Tulsa, and has a doctorate in English education from the University of Oklahoma.
She has been published in numerous journals, written chapters in textbooks and even helped develop some of the Common Core education standards used in Arkansas and Oklahoma.
Good assignments don’t just hit one Common Core, they hit many, Whiting says.
“I teach for life, not just for kids going to college,” Whiting said. “(Common Core) scares a lot of teachers, but I think it challenges them to quit thinking that reading and writing comes from English teachers — it’s not the English teacher’s duty; it’s every teacher’s responsibility to make sure our students are literate. I think this pushes math, science and history teachers that they teach literacy skills as well, like a lab report or a word problem. It’s bigger than just English. It’s about teaching about life. That’s what I find the best about it.”
Whiting has taken that philosophy to co-author a textbook for high school English classes that has become the second-best-selling book in its field.
She co-wrote “Language and Composition: The Art of Voice” with the late Gilbert H. Muller, professor emeritus of English at the LaGuardia campus of the City University of New York.
The book, published by McGraw-Hill, caters to Advanced Placement English Language and Composition students in grades 9-12 and engages them in writing through a varied anthology of essays that include print, audio, visual and interactive media, Whiting said.
Advanced Placement is a program in the United States and Canada offering college-level curriculum and examinations to high school students.
The textbook was released for school review in February 2013. Whiting said it plays to the Common Core standards, which is why many teachers are receptive to it.
McGraw-Hill approached Whiting in May 2012, wanting her to rewrite and add to the existing textbook. She helped add new essays to the book and worked on rewriting it for the last six months of 2012.
Essays collected in the textbook range from classical works by Frederick Douglass to contemporaries such as Sherman Alexie.
David Anderson, English department chairman at Hinsdale South High School in Illinois, said he enjoyed the selection of essays.
“I like the focus on more modern topics like technology and helicopter parenting,” Anderson stated in a news release. “I could see myself cannibalizing some of these selections for close reading analysis.”
Ashley Gerhardson, instructional facilitator for English and social studies at Darby Junior High School and former student of Whiting’s, says although the textbook is not in use at Darby, she tries to incorporate elements of it into the classrooms.
“I think the main thing I’ve taken away from it is the methodology, not specific methods she’s used, but her tools she uses to challenge students,” Gerhardson said. “Specifically by looking at interactive and visual texts, I try to incorporate a lot of those things at Darby to help our students be better learners. The key thing from her book is getting them involved in their learning.”
Whiting said the book has been a monumental success.
“Here I was, sitting down in Fort Smith, Ark., and McGraw-Hill calls and asks me write this monumental book,” Whiting said. “It hit me pretty hard, because they’re very renowned, and I thought, ‘You’ve got to be kidding me.’ It’s unbelievably rewarding and amazing it’s been well received.”
She says the methodology in the textbook is more than just text, but about testing your limits.
“I try to explain that to my own students, to write from your gut,” Whiting said. “I give people more points for being brave than trying to write something that didn’t take a risk.”
Whiting’s influence goes beyond that of the classroom and her published works, as she has become influential in her students’ lives.
“Her main influence on me was that it’s not just about the content you teach, it’s about maintaining a rapport with your students,” Gerhardson said. “She taught me the importance of building and sustaining relationships after you finish your teaching is the most important thing you can do as a teacher.”
Gerhardson, a 2007 UAFS graduate, said she took Whiting’s courses for three years and has kept in touch with her, considering her a mentor and a friend.
“I lost my mother 3½ years ago, and she called me as soon as she heard,” Gerhardson said. “She’s not one of those professors you’re scared to approach. When I need to talk to someone, she’s that person. She’s passionate about not only the subject, but the students needs.”
Joe Hardin, dean of the College of Languages and Communication at UAFS, said he considers Whiting an asset to the university.
“We are very proud of her, and we encourage our staff to continue to learn and develop. This is very much a part of what we do here,” Hardin said of Whiting.
Whiting says she is getting ready to start another book and has plans to retire “who knows when” to her second home in Grand Lake, Okla.
She and her husband, Jim Zacame, have two daughters, Molly, who works in insurance and lives in New York City, and Megan, an attorney in Birmingham, Ala.