The Samba-Bugzilla – Bug 8523
wbinfo --user-domgroups sometimes doesn't return local groups
Last modified: 2012-06-12 12:56:19 UTC
Created attachment 6997 [details]
Fix lookup_usergroups() for local groups
After some hours of debugging I figured that the function lookup_usergroups_cached() in winbindd_utils.c seems to return a cache entry without any local groups, i.e. without groups that are present in the ActiveDirectory only in the scope of a certain domain. This causes the function lookup_usergroups() from winbindd_ads.c to return directly after a cache hit. This in turn causes the shell command 'wbinfo --user-domgroups=$usersid' to return only the global ActiveDirectory groups the user is a member of.
The issue is rather hard to reproduce as you need to:
- get a lookup_usergroups() called at all, and
- have a situation where lookup_usergroups_cached() returns non-NULL
I worked around the issue by not calling lookup_usergroups_cached() at all from lookup_usergroups(), which seems to be okay because caching seems to happen at a higher level too.
The used AD server is a Windows Server 2008 R2.
This is going to take some looking into, mainly as it's not easily reproducible. Just wanted you to know this might not get into 3.6.1.
Jeremy.
I think it is possible to reproduce by following sequence:
1.) remove all .tdb files and restart winbindd
2.) run 'wbinfo --user-domgroups' for the sid of user $foo
3.) let the winbind cache expire (winbind cache time default is 600s)
4.) run 'wbinfo --pam-logon' for user $foo with the correct password
5.) right after that query user groups again using 'wbinfo --user-domgroups'
At stage 2.) the usergroups may still be complete, but at stage 5.) I believe the local groups are missing in the results.
However, from my point of view no need to defer Samba 3.6.1 for this bug...
This issue (or at least identical symptoms) is still present in
winbind 3.6.3.
When using winbind to integrate into AD on SLES11 SP2, winbind fails to enumerate "domain local groups" after the initial winbind cache expiry time is hit on second logon.
Steps to reproduce:
1) integrate into AD using winbind / kerberos
2) use pam_winbind for ssh login
3) create AD user with both global security groups AND domain local groups
4) log in using the ad user via ssh
5) logout, wait min. 10 min (winbind cache expiry time)
6) login again, check wbinfo -r <username>
Results for me :
before cache expiry: (after step 4)
wbinfo -r <username> | wc -l
97
after cache expiry: (after step 6)
wbinfo -r <username> | wc -l
18
Environmental Details:
SLES11 SP2 with latest patches
winbindd -V
Version 3.6.3-0.24.4-2794-SUSE-CODE11-x86_64
(SLES 11.2)
This bug does not occur on SLES11 SP1:
winbindd -V
Version 3.4.3-1.40.3-2791-SUSE-CODE11
Kind regards,
Sebastian Juerges