Challenging a colonial Inheritance
Giving First Nations a stronger legislative voice by electoral reform
By PAT CARL
Usually I like to write about my successes as a teacher. But sometimes it’s healthy to confess failures. So, here goes.
Bless me, readers, for I have sinned.
While instructing at North Island College in Courtenay, I was assigned to teach English 115, which is a basic composition class that all first-year students must take. The English Department encouraged instructors to create themes for those classes.
During one such class, I thought it might be a good idea to follow the advice of the Truth and Reconciliation Commission. I provided an opportunity for students to think about the way First Nations people have been portrayed in dominant literature and cinema and to consider alternative views from a First Nations perspective.
Now, if I had to describe myself, I’d have to say I’m a chubby white girl, mostly Irish, a fallen-away Catholic, raised middle-class, a social-justice liberal, an environmentalist, a gardener, a sometimes-writer and a lesbian.
Do you see anything in that list that qualifies me by any stretch of the imagination to conduct a class about the biases prevalent in literature and film regarding First Nations, never mind present an alternative view from a First Nations perspective?
That’s right. Nope, nada, nothing.
In retrospect, I realize it was unwise to address such an ambitious theme without consulting and collaborating with at least one First Nations elder at the college.
And that’s the rub. However well-intentioned, too often white Euro-Canadians have decided for First Nations what’s best for them. Think residential schools. Think the Indian Act. Think of all the recent decisions made by Canada’s federal and provincial governments regarding pipelines and the building of dams.
Unlike Canada, other countries, at least recently, have managed to engage more respectfully with Indigenous peoples.
For example, look at the Maori Party in New Zealand.
When the Maori Party helped to form government, it introduced traditional approaches to New Zealand’s social services and child welfare systems; the party influenced government expenditures that targeted poverty abatement and the elimination of homelessness; the party improved the delivery of education among Maori youth; the party defended and expanded treaty rights; the party secured monies targeting the environment in order to improve Indigenous lands; and the party worked to place the delivery of the Maori language and culture in the hands of Maoris.
To be clear, all of these Maori political achievements were accomplished since proportional representation replaced first-past-the-post as that country’s voting system. While New Zealand provides a federal example, there’s nothing that limits that example from being applied provincially in BC. The New Zealand example shows how a proportional electoral system can be a change-maker for Indigenous peoples that first-past-the-post doesn’t provide.
And there I go again.
It’s so easy for privileged people like me to forget that, even with the best examples at hand, like those offered by the Maori in New Zealand, it’s not up to me to decide. It’s not up to me even to suggest.
With that in mind, let’s consider How We Vote: 2018 Electoral Reform Referendum, the report and recommendations which was released on May 30 by Attorney General David Eby. And let’s consider specifically the results of a survey conducted among an admittedly small number of Indigenous leaders and youth as well as among members of two Bands. The survey results are documented in Addendum I, “Indigenous BC Elections Referendum Survey Results.”
Of the 132 respondents to the survey, “73 percent do not feel that Indigenous voices are currently adequately represented in the Legislative Assembly” in Victoria. Additionally, First Nations leadership called for “designated Indigenous representation in the Legislature.”
Further, more than half of all respondents to the survey want “better representation of groups that are currently under-represented in the Legislative Assembly.” Another 38 percent want members of the Legislature to “cooperate to make decisions,” and a total of 81 percent want a spirit of greater compromise to inform Legislative decision-making.
All of these assertions are overlaid by 81 percent of respondents who either strongly agree or agree that a “greater diversity of views” should echo throughout the halls of provincial governance.
Most telling are the narrative comments made by 20 of the respondents at the end of the survey.
Some were concerned about how MLAs and parties receive funding from corporate and wealthy interests, which causes legislators to be unduly influenced by the privileged one percent rather than being concerned about the interests of their constituents.
Others were concerned about how little attention the legislature pays to ensuring that Indigenous peoples, especially those in remote locations, have easy access to the polls.
But, what struck me the most were the multiple respondents who believe that First Nations need to be included in the Legislative Assembly as MLAs. This may require, as some suggest, the establishment of First Nations’ Legislative Assembly set-aside seats. Additionally, respondents assert that the Indigenous people who occupy those seats be selected by Band members in transparent elections.
A system of voting that represents the will of people, a system that provides a way for making sure everyone can vote, and a system that finally hears the voices of the most excluded voters in Canada.
Sounds like support for the principles of proportional representation to me.
Pat Carl is a member of Fair Vote Comox Valley and a Citizen Journalist for The Civic Journalism Project. She may be contacted at patcarl0808@gmail.com