By Dr Heather Brunskell-Evans
This article was originally published on The Question. See original article here.
In contemporary western societies, almost everything we women and men do has been influenced by feminist theories.
Women can vote and can help shape public life without being vilified as ‘un-feminine’. Men can look after their babies, pick up their small children from the school playground, and perform jobs traditionally associated with women without being scorned as ‘unmanly’. The belief that men are human beings who can nurture, and that women share with men equal intellectual and moral capacities, emerge from feminist theories. Such ideas have largely been integrated into the culture as common sense, but they were once revolutionary, and in many instances, were greeted with hostility, even ferocity.
Over the centuries feminist philosophers have re-envisioned masculinity and femininity. Mary Wollstonecraft of the 18th century forcefully wrote about the rights of women at the precise moment that ‘human’ rights were being accorded to men only (ref: A Vindication of the Rights of Women). There have been some men who have also championed the feminist cause, for example John Stuart Mill, in the 19th century (ref: The Subjection of Women). In the early 20th century the suffragists and suffragettes campaigned for women’s rights to vote, imagining that this would secure women’s equality and put an end to women’s social subordination.
In the 1960s, and 1970s when the right to vote had been acceded but had not ameliorated the subordination of women at home, at work, and in sexual relations, there was an explosion of feminist theories which analysed the relationship between the personal and the political. The patriarchal family, women’s predominant responsibility for childcare, the sexual double standard, unequal pay, pornography and prostitution, were only some of the issues feminists analysed. Feminist grassroots activism, theoretically informed, helped change attitudes which brought about the Equal Pay Act 1970 and the Sex Discrimination Act 1975.
In the last 50 years, the family, the work-place, education, and sexual norms and values, have substantively changed. But unless we delude ourselves, we should also recognise that patriarchy is still alive and kicking.
Regarding the gender pay gap, a Polish MP has recently argued that women should get paid less because we are by nature weaker and less intelligent.
Clearly the courage displayed by our grandmothers and mothers is still needed to resist patriarchal ideas. Traditionally men have not been happy with the feminist challenge to the patriarchal social order. Why would they be? Patriarchy benefits men, broadly speaking, and dismantling it means an initial reduction in their privilege and status.
Societies are never static, and are always developing and changing. Theories emanate from several sources, including from developments in science and technology. Ideas clash and compete, and how some theories become hegemonic at any one moment is a matter of contingency and the play of power politics. Women – as scientists, writers, artists, and philosophers – have always contributed to this historical change even though, in comparison with men, they have had more impediments, fewer role models, reduced educational opportunities, and less economic resources.
History demonstrates we inherit a legacy of forgetfulness about the contributions of feminism. Each new generation of young women is largely unaware that feminist ideas have been instrumental in forging the freedoms they take for granted.
Perhaps this is because once feminist arguments have become accepted, men and women often feel the personal benefits of the changed social order and imagine there is no more work to be done. It is only when a new generation of women realises how precarious women’s rights can be and that patriarchal political forces are still thriving that they wake up from cultural amnesia. I think this is happening right now, otherwise this question would never have been asked!
See more information in the author's recent book, analysing the relationship between pornography, sexualised inequality and sexology The Sexualized Body and Medical Authority of Pornoraphy.