Not that long ago, cybersecurity was an issue for the back room. Now, it’s made its way to the boardroom and the Situation Room.
In February, President Obama issued an executive order aimed at protecting critical infrastructure, adding the administration’s voice to those of Congressional members and corporate leaders in the national conversation on cybersecurity.
Just as government and industry coordinated the telecommunications response after the 9/11 terrorist attacks, the order enlists both public and private entities in assuring that critical infrastructure is continuously monitored and protected from attack.
Cyber threats are growing in intensity and scale. We’ve seen significant breaches at government agencies and in private businesses, including leading financial institutions and large U.S. media companies. Recent allegations of the theft of top-security information connected to the development of sophisticated weapons and air defense systems have only heightened concerns about the security of the nation’s networks.. The National Institute of Standards and Technology (NIST) wants a preliminary framework in place by the end of this summer, with a final set of guidelines ready to go in February 2014.
The response to today’s cyber threats can’t be limited to Washington. Cybersecurity isn’t just about compliance with laws and regulation — it’s about guarding businesses from the increasing dangers of persistent threats. As importantly, an effective cybersecurity framework has to overcome barriers to continued economic growth — creating an environment that protects and nurtures innovation.
Certainly, the environment is complex. Critical industry sectors from energy and banking to transportation and health care answer to different government agencies or regulators. Therefore, it is imperative that any designated corporate cybersecurity officer sustain strong working relationships with appropriate government stakeholders.
It’s encouraging that many business leaders understand the threat. A growing number of corporate boards are demanding regular updates from CISOs or CIOs on their states of readiness. Corporate executives should be asking themselves: how can public and private organizations work together most efficiently; how should a productive relationship develop between the two sides on key cybersecurity issues; and how can threats be addressed while protecting intellectual property and individual rights to privacy?
It is critical that the public and private sectors work together to build a cybersecurity framework that takes into account the very legitimate business concerns of maintaining individual privacy obligations, securing corporate proprietary information, and safeguarding competitive positioning, while promoting an efficient exchange of information.
Not all attacks rise to the level of a Page One headline. In fact, many breaches can damage businesses in significant ways without triggering news attention. Vandalism of websites to full-fledged short-circuiting of networks lead to theft of intellectual property, fraud, and in the most extreme cases, threats to corporate survival.
Take, for example, the energy industry: According to one recent Congressional report, the computer systems that drive the U.S. electric grid are under frequent — even daily — attack. That survey of corporate officials found striking examples of ongoing attempts to steal critical information; one company reported experiencing 10,000 attempted attacks a month.
Every C-level executive has a role in stemming the tide of cyber-attacks. It’s not the responsibility of the CIO or even the CEO alone; COOs, CFOs, CROs, CPOs, and the corporate board should be equally invested in sharing active responsibility for the effort. A comprehensive corporate cybersecurity strategy is required.
To that end, all business leaders should adopt the following four steps:
Understand the challenge: An organization’s threat profile must be top of mind for all leaders. Creating ongoing monitoring methods and finding resolutions to reporting challenges would allow executives to see well ahead of the curve. Risk intelligence is perhaps more valuable in 21st century business than conventional business intelligence.
Establish accountability: Company management should be requesting quarterly reports on the organization’s most pressing cyber threats, to ensure that executives develop, track, and chart metrics which would enable them to quantify the impact of any intrusion. One designated leader, whether the CIO or other senior-level executive, could serve as the nexus for all cyber activities.
Coordinate efforts: A unified approach needs to be exactly that — unified. Assure that cyber security is well-managed not only through company headquarters, but all along the supply and value chain. Developing an effective national system to secure our critical infrastructure requires the coordination of key elements: protocols, sharing of sensitive data, and IT strategies.
Communicate: Government regulation and corporate risk management activity is at a high level. Cyber security officers should maintain regular communication with their industry associations and government contacts to make sure that industry perspectives are heard. Given the pervasive, business-critical role of IT and value of high-tech assets, the case for increased transparency and dialogue among stakeholders has never been stronger.
Nationally, we spend hundreds of millions of dollars on detecting, neutralizing, and recovering from cyber-attacks. There is perhaps no more important financial aspect of running a business these days than data maintenance and security.
While the cost of building an effective cyber defense system could be high, the cost of not doing enough may be even higher. One thing is certain: cyberattacks won’t stop while we discuss how to build a protective network, who should run it, and the price tag for implementation.
The solution starts with cooperation across public and private lines, and collectively putting the greater good — America’s national security and economic competitiveness — at the top of our priority list.