Ten basic concepts to explore "possibilities” for "eating local, buying local” food.
In the 1980s we, grandmothers and grandfathers, were seeding the plants that have grown into today’s organic movement. I recognize the same message in the ‘100 mile diet’ that we were stating: ‘Eat local, buy local’.
We also were conscious that what we bought from outside our region had to be evaluated for a few principles. Were the farmers being given a fair price for their crop? Was land being taken from people to produce the ‘cash crop’ we were buying? Was the company ‘ethical’ in their treatment of soil, people and the crops? Many of us boycotted grapes for years because of the human rights violations with countries selling grapes in Canada.
My heart is happy when I hear the next generation raising the call with the ‘100 mile diet’. Let’s all join hearts, hands and minds to help create a food system.
In 1987 I was on the CBC Sunday Morning Food Show with host Bruce Steele. He asked me ‘how do you feel about being called the ‘lunatic fringe’? which was what the organic movement was seen as, fringe and impossible.
My reply was ‘it’s a way of looking at local land and food issues that can only gain in popularity and in twenty years this should be mainstream’. I always hoped that it would be the farmers spraying chemicals and adding industrial strength pollutants to the soil that would need to be ‘certified’ and spending hours doing paperwork to be allowed to pollute the planet. Instead, regulations have made the hurdles higher for small scale farmers to do the certification fees and paperwork to grow foods in harmony with nature, organically.
In 1987 I began to grow a ‘possibility’. I grew heritage wheats including ‘Red Fife’ wheat. I started with one pound of ‘Red Fife’ wheat and today we are, from that one pound of seed, seeing fields of this glorious old landrace adapting to fields from coast to coast. ‘Red Fife’ is one of hundreds of heritage varieties of wheat that we can field trial as possibilities.
There are 100,000 varieties of wheats that make bread. ‘Red Fife’ is one variety. Then there are dozens of varieties of spelt, durum, emmer, einkorn, kamut and other types of wheat. Same with all other crops.
Not all heritage crops will adapt to all regions. Nor do all hybrids adapt to all regions. But trying a new seed starts with a ‘possibility’ thought. "What if that variety will adapt here?” and we begin to taste the end results.
Often you get a small quantity of seed, put it into the ground and in a few years you are feeding your community with the results of your efforts; and then swapping the surplus for crops that others are growing. But it starts by experimenting with varieties, not just crops. Get as specific in the variety choice as you can.
When you bring the People, Plant and Place together you just never know what will grow. Anything is possible. That’s the miracle of the seed.
Ten steps to Growing the 100 mile diet:
1. Identify the foods that are your food choices; don’t exclude what you can find today within the 100 mile range at this stage.
Remember possibilities.
2. Identify what’s currently being grown within the 100 mile radius and also start searching for people who are passionate about the crops not being grown at present.
3. Then break the ‘food’ into ‘possibilities’. For example ‘wheat’ is not just ‘wheat’. When we consider the heritage variety ‘Red Fife’ that is a landrace variety of bread wheat. But there are hundreds of varieties of bread wheat to try that might be ‘possible’ to grow in each region. And then there are pasta or durum wheats that can be blended with bread wheat for various kinds of food including pasta. Same idea happens with the various ‘types’ and then ‘varieties’ of corn, millet, beans, etc.
4. Identify people who know about each of the possibilities you might want to source. You might start looking in the Seeds of Diversity Canada () and your local ‘Seedy Saturday’ seed exchange site of small seed companies. Ask them about their local experience with your possibilities and very likely they will have a good source of seed.
5. Identify sources of seed for the possibilities and then get the seed.
6. Identify places where you can grow the seed. You may not have land yourself but who can you partner with to have your seed grown out? Experiment with what grows in your region.
7. Can you develop a CSA (Community Shared Agriculture) model in your community that will include the ‘possibilities’ in each week’s food basket?
8. Once you have identified the ‘possibilities’ that grow well in the region, and found the seeds, found land to grow the seed, and a method to distribute the food (WOW!) then you are ready to enhance the taste and nutritional content.
9. Grape growers and wine makers have developed ways of developing a ‘taste palette’ for each ‘possibility’ that has proven itself in the region. Why can we not do the same to expand the amino acid content, the foundation of proteins that provide nutrition and food qualities in all the foods we eat?
10. Celebrate the seasons with community celebrations around the seed. There are the spring rituals for a fertile and prosperous growing season and blessing the seeds of new possibilities. Then the weeding and the summer heat to bring maturity to the possibilities. Then the new seeds form and also the fruits of the labor. Harvest these fruits that are proof and remembrance of the abundance of the Mother Earth. Share the abundance and prepare for a period of rest and reflection and dreaming about next year’s ‘possibilities’. And then the glorious cycle begins again connecting people, plants and place.
Sharon teaches people about developing community food systems and conserving agriculture biodiversity. She is the founder of the ‘Seedy Saturday’ and the ‘Red Fife’ wheat movements. Email: slrempel@shaw.ca and visit her website for upcoming courses:
This entry was posted on Wednesday, May 2nd, 2007 at 9:22