Please enable Javascript in your browser.
Researchers worldwide are working to develop new technologies for producing clean energy. A team of researchers led by Sven Kerzenmacher at the University of Freiburg's Department of Microsystems Engineering (IMTEK) is interested in combining wastewater and bacteria, an approach that is both unusual and promising.
Even though current low oil prices do not appear to signal that fossil reserves such as oil and coal are finite, there is no doubt that they are. And as the global population – and hence energy needs – continues to grow, new technologies that generate CO2 neutral, clean energy are required. Neither solar and wind energies nor energy crops alone are able to solve the global energy problem. Algae and bacteria are regarded as promising new resources for energy production.
The team led by Sven Kerzenmacher from the University of Freiburg's Department of Microsystems Engineering (IMTEK) uses a particular resource for producing energy that has not previously been considered: wastewater. “In theory, we only have to put two electrodes into the wastewater at a sewage plant and it's not long before a biofilm forms on the electrodes with which electric current can be generated,” says Kerzenmacher.
Microbial fuel cells generate electricity in the same way as conventional fuel cells by converting chemical energy into electrical energy. Bacteria use the organic constituents that float in wastewater as food. The oxidation of food molecules, which happens in all living organisms, is associated with the transfer of electrons. The researchers from Freiburg have found a way to tap into this electron flow and generate electricity. “The bacteria act as catalysts. But they are considerably cheaper than the platinum used in normal fuel cells,” says Kerzenmacher.
However, only a handful of bacteria are suitable for generating electric current. “They must be able to transfer their electrons directly to an electrode,” says Kerzenmacher. An example of such an electrode is an anode made from porous stainless steel or graphite. Only exoelectrogenic bacteria have this capacity. The researchers from Freiburg work with Geobacter sulfurreducens, a bacterium present in soil and therefore also in wastewater. These bacteria are able to oxidise organic compounds by transferring electrons to electrodes. They have special proteins that transport the electrons produced by organic matter oxidation across the cell membrane to the outside where they are transferred to a fuel cell anode as the sole electron acceptor. Usable electric current is generated when these electrodes flow from the anode to the cathode through a wire.
However, there are even more effective ways of generating power: Joana Danzer, a scientist in Kerzenmacher’s team, works with so-called filtration-active microbial fuel cells that, in addition to producing electric current, also clean the wastewater. “This tubular fuel cell has a membrane anode that serves as both filter and electrode,” says Joana Danzer who developed this fuel cell variant as part of her doctoral thesis at the IMTEK Laboratory for MEMS Applications (see figure). In October 2014, she won the Baden-Württemberg Ministry of the Environment's f-cell award.
Joana Danzer has used synthetic wastewater to develop the fuel cell, but will now test it with real wastewater. She will also have to find alternative anode materials for the two fuel cells as porous stainless steel would be far too expensive for commercial use. In the long term, the researchers also plan to test the miniature cells on the large scale as the industrial application of the technology requires square metres rather than square centimetres. “We do not yet know what kind of problems will arise when we scale up,” says Kerzenmacher.
The researchers will also have to increase current density. “We are currently able to produce around one to two watts per square metre, but the system only pays off from 5 to 10 watts or more,” says Danzer. The researchers’ goal is, however, not to supply entire cities with electricity. “We would have achieved a lot if we manage to produce fuel cells that can cover the power requirements of sewage plants,” concludes Danzer.
Sewage plants are real energy guzzlers. Wastewater aeration is particularly expensive but necessary as the microorganisms used to clean wastewater need oxygen. According to the Federal Environment Agency, sewage plants consume on average 20 percent of the overall energy used by German towns and cities, making them the largest municipal energy consumers. Annual energy consumption in wastewater plants in Germany amounts to around 4,400 gigawatt hours, which corresponds to the energy needs of 900,000 four-person households. Huge savings would be made if some of this energy could be directly produced in the sewage plant.
The researchers from Freiburg want to focus initially on industrial wastewater from breweries or food producers. “The wastewater of such organisations is usually more heavily polluted than municipal wastewater. Cleaning or disposal costs are relatively high. I think that these kinds of organisations would be interested in our technology,” says Kerzenmacher.
In addition to energy-neutral wastewater treatment, the microbial fuel cell can also be used for other applications. One variant can be used to produce hydrogen, and another could be used to indirectly produce biopolymers by feeding bioplastics-producing bacteria with fuel cell electrons instead of sugar as is the case at the moment.