Who Gave These Nice Catholics Guitars? How to Endure Ugly Church Music, and Other Aesthetic Matters
“There is a singing group in this Catholic church today, a singing group which calls itself the ‘Wildflowers’. The lead is a tall, square-jawed teen-aged stand a frail, withdrawn fourteen-year-old boy, and a large Chinese man in his twenties who seems to want to enjoy himself but is not sure how to. He looks around wildly as he sings, and shuffles his feet. There is also a very tall teen-aged girl, presumably the lead singer’s girlfriend; she is delicate of feature, half serene and half petrified, a wispy soprano. They straggle out in front of the altar and teach us a brand-new hymn.?”
—Annie Dillard, Teaching a Stone to Talk
Annie Dillard plagiarized my interior monologue. “Who gave these nice Catholics guitars?” is a refrain I silently repeated to myself for the duration of my time as a(n ultimately defective) catechumen at a Catholic parish. Vatican II theology, its openness and philosophical depth, is what initially drew me toward Rome; Vatican II church music, which in some parishes transformed traditional Mass settings into Broadway song-and-dance numbers, or worse, campfire banjo strumming, sent me pleading for the Tridentine reverence I had imagined as an alternative to the bad aesthetics marking most of my prior church experiences. (Lest I sound like a decadent asshole, I must clarify that my reasons for defecting from the RCC were more complex than simply a distaste for the jazz-ification of the Gloria).
I later attended an Anglican church that, in virtue of its Anglicanism, never underwent Vatican II musical reforms, and which satiated the desire for a highly formalized liturgy; it had all the smells (incense) and all the bells, an enormous organ, and the original language from the Book of Common Prayer. Shocker: we only sang hymns, all eight (or more) verses. That’s what the author (and apparently the good Lord) intended. Some hymns were spectacularly terrible, but sang them we did, because the Wesleys were prolific. Some Mass settings were totally enrapturing and deftly executed (such as the one at our wedding, which was the most heavenly musical experience of my life).
Moving to California, where high-church Anglicanism mostly doesn’t exist, meant ceding aesthetic preferences in search of community. Having become deeply habituated to the carefully structured liturgical rites, choral ensembles, and general sobriety of the Mass, it’s been a shock to my system to re-enter the land of praise band piety. Frankly, it’s been an obstacle to prayerful contemplation. Sometimes we sing hymns from the church’s Greatest Hits list and I rejoice; sometimes during the particularly excruciating Phil Wickam songs I slip off to the bathroom until it ends, returning to very dirty looks from my husband, who’s onto my not-so-subtle scheme.
This adjustment to a new form of Christian worship has led me to wonder whether my strong emotional response (ranging from discomfort to moral outrage) is based on totally idiosyncratic preference and disposition, or on a more objective rule that certain musical forms are better suited to the task than others. The most abstracted version of the fundamentally aesthetic question I’m asking is: how does form relate to and affect content? More specifically, how does the musical form employed in a religious service affect, underscore, undermine, veil, or reveal the content of that service?
Is there a set of musical forms better suited to Christian worship than other musical forms? Are any musical forms entirely out of bounds? Christians seem to be comfortable demarcating certain practices as appropriate for Christian worship, such as the production of live music, while deeming other practices outside the bounds of Christian worship, such as hiring and sleeping with a prostitute. Can we make the same discriminating choices about musical form? Or is it all a matter of individual preference (e.g. “I loathe 80s power ballads but I love contemplative Jewish melodies, ergo I’ll attend a church that goes heavy on Taizé”)? Ought we ban instruments and return to 2nd century chants? Ought we allow jazz trios, electric guitars, banjos, synthesizers, organs, and African drumming to each serve communities according to preference? (My guess is: probably). And how ought melodies compliment lyrics? How ought the music of lament differ from that of rejoicing? Ought religious services include both genres in their narrative arc?
And perhaps more primarily, what is the content of the service? Surely that answer will affect what musical form one deems appropriate. Is the Sanctus part of the form, or the content? How do you divvy them up? Latin was presumed to be the only appropriate form of the Catholic Mass for centuries; in that scenario, the medium is the message, the form is the content. Latin itself becomes an inextricable part of the gospel on that view, since only it can adequately convey the sacramental concepts therein (there is of course an analog claim about sacred language being made in Islam vis-à-vis Arabic, in which all of its prayers and services are conducted). Vatican II’s decision to allow vernacular masses in the language of the local parish indicated a distinction between form and content; the gospel, the content, could be delivered in myriad linguistic (and musical) forms.
On the other end of the spectrum, there are evangelicals who totally separate form and content, arguing that any medium will convey the message, and thus any form is adequate for worship; what’s to distinguish Cheetos and beer at a Phish concert from the bread and wine of an Easter Mass? This quickly becomes a question about the nature and role of materiality writ large in relation to the divine (cue realist-nominalist arguments about the Eucharist), as well as about the function of tradition and whether continuity of practice trumps cultural “relevance” when organizing a service. One enters a mine-field as soon as one tries to absolutize the best way to conduct ritual worship. These questions of musical form lie at the center of a pulsating nerve of perplexity; I should stop pretending to have answers. We may spend our graduate careers and entire pastoral ministries in pursuit of them.
If nothing else, this is a plea for reverence.

Eva
- Teaching as Hospitality - January 26, 2015
- How Performative Is Gender? - November 17, 2014
- A Stranger to Myself: What a Heart Transplant Tells Us About Personhood - October 17, 2014