Considering OCR Agreements, the Challenges of Operationalizing Choice and Authorizer Accountability./
by Paul O'Neill
Three recent publications highlight some of the key challenges the National Center for Special Education in Charter Schools faces as we work to ensure students with disabilities have ready access to charter schools prepared to provide quality special education and related services. We discuss them in chronological order.
1. On November 26th, the U.S. Department of Education Office of Civil Rights published a negotiated agreement (Agreement: Harmony Public Schools, Texas: OCR Case #06-11-5004 -- November 26, 2014 (PDF) - harmony-public-schools-agreement.pdf) with Harmony Public Schools (Harmony), a network of charter schools operated by the Cosmos Foundation. The agreement stemmed from a complaint regarding the network’s enrollment and education of English language learners and students with disabilities. Harmony operates 43 charter schools in 15 districts across the state of Texas, enrolling a total of 28,500 students. The complaint alleged that Harmony had violated multiple federal civil rights laws.
In response to the complaint, OCR investigated a subset of Harmony charter schools. While the proportion of English language learners and students with disabilities in local districts averaged, 22.5% and 7.3% respectively, the charter network enrolled 11.5% and 2.7% respectively. These differences are statistically significant. Harmony drafted a set of recommended corrective actions focused on improving recruitment, enrollment, and data monitoring prior to OCR’s decision. The case is noteworthy on multiple fronts but most relevant to our mission is the fact that OCR did not find any evidence of noncompliance in Harmony’s written policies that might account for the low enrollment of students with disabilities.
While discerning the root cause of the enrollment trends was beyond the scope of the OCR investigation, the findings and corrective actions raise more questions than answers. For instance, given the large size of the network and significant enrollment trends, what role did the authorizer play in tracking issues related to equity or holding the network accountable leading up to the OCR complaint? Formal policies are the first step in ensuring access but the golden ring associated with enrolling students with disabilities is quality programs that enable students to succeed. We do not have first hand knowledge of Harmony and are therefore cautious about making assumptions. Nevertheless, the agreement led us to wonder if the numbers are a byproduct of an unfortunate cycle wherein schools offer inadequate services leading to development of a reputation as a school that does not provide services which leads to fewer parents applying to enroll. If this is the underlying cause of the worrisome enrollment data, the network will have to commit to intentionally improving the quality of the programs offered to students with disabilities in addition to reviewing their recruitment and enrollment practices. Furthermore, the state of Texas should be reviewing authorizer practices to ensure appropriate procedures are in place to monitor issues related to equitable access to charter schools.
2. The Center on Reinventing Public Education’s new report, Making Schools Work: How Parents Experience Public Choice: crpe_how-parents-experience-public-school-choice_0.pdf, arrived amidst our considering the implications of the OCR-Harmony agreement. The report presents findings from surveys of parents/guardians in eight “high-choice” districts. The survey affirmed that parents want good educational options for their children but that choice manifests in varying ways in different cities and for different parents. Of particular interest, the CRPE team found that “parents with less education, minority parents, and parents of special-needs children are more likely to report challenges navigating choice.” More specifically, parents of students with disabilities reported having difficulty finding “a school that fits” and confusion regarding eligibility for various choice options in their district. Returning back to examining the OCR decision, we wondered what role perceptions about fit and eligibility may have influenced enrollment at Harmony schools in Texas.
3. The third item that crossed our desks this week that gave us pause was the National Association for Public Charter Schools’ report on state authorizer policies: “On the Road to Better Accountability: An Analysis of State Charter School Policies:. NACSA is to be commended for leading the effort to demand quality in the charter sector and pushing states and authorizers to adopt robust principles and standards and to close failing schools. Of particular interest to us, the principles and standards articulate expectations related to considering special education and related services for students with disabilities during the application and renewal processes. The report opens with a bold assessment: “Every charter school has an authorizer. Yet in most states, the laws that govern charter schools and authorizers are weak or vague about school quality and accountability. Most state charter school laws need to be clearer and stronger.” Yet, while NACSA’s principles and standards document addresses special education, the new report has a notable gap in that it does not include examination of state charter policies related to students with disabilities.
Coming full circle, ensuring that access and quality programs for students with disabilities is part of the discussion regarding charter school quality is the entry-level of our focused efforts to drive change that will improve not only access but outcomes for students with disabilities. We need to make certain that authorizers are paying attention to special education AND being held accountable for policies and procedures that influence access and provision of services. Absent attention at the state and local level, we will have far more OCR complaints (e.g., the ACLU filed a complaint against charter schools in Delaware alleging discrimination by race, income and disability on December 5th) stemming from tacit acceptance of lack of access. If we are going to try and expand access and ensure that a student’s disability does not limit their options, we must pay attention to how choice is operationalized for parents of students with unique learning needs. While we can tinker with policies and review enrollment forms, until we ensure that charter schools are prepared to offer quality programs and held accountable for failing to provide quality programs, we will most likely continue to see increasing numbers of OCR investigations and corrective action plans.
December 15, 2014