Diet Drinks: The Hidden Dangers
Most people know how harmful sugary drinks are for our health. But could “diet drinks” with artificial sweeteners be just as dangerous? Or worse? Let’s look at the evidence:
- A 2017 study published in Stroke followed 4000 adults over 45 years of age for 10 years. The study found a three-fold risk of strokes and a three-fold increased risk of developing dementia in those taking the equivalent of one can of diet drink daily.
- A 2019 study followed 81,000 post-menopausal women for 11 years. It was also published in Stroke. It found those taking 2 or more diet drinks daily (compared to those taking one or less per week) had 29% more heart attacks, 31% more ischaemic strokes and a 16% greater chance of premature death. Those with obesity had a 200% higher risk of ischaemic stroke, those with diabetes or heart disease had a 240% increased risk of stroke. African American women had a 400% increased risk of stroke.
- A huge study done by the World Health Organisation followed 450,000 adults in 10 countries. It found that those who drank 2 or more (250mls) diet drinks daily had a 26% increase risk of early death over the next 16 years.
- A study from Columbia University found a 43% increase in heart attacks and strokes for those having one or more artificially sweetened “diet” drinks daily compared to those having none.
To put these studies in perspective, for those who have had heart attacks and strokes the dangers of continuing to drink diet drinks would greatly outweigh the benefits of any medication being taken.
- A study of 1550 adults found that those who used diet drinks gained more weight than those on other soft drinks. Each can or bottle drunk daily was associated with a 41% increased risk of being overweight.
- In 2013 a study was published that followed 66,000 French women for 14 years. It looked at the risk of developing type 2 diabetes from drinking sugary drinks and diet drinks. Those taking 500mls weekly with either sugary or diet drinks increased their risk of diabetes by about 50%. But surprisingly for those taking 1000 mls of sugary drinks weekly the risk of developing diabetes did not increased further but the risk of diabetes doubled in those taking diet drinks. The Multi-Ethnic study found a diet drink daily increased the risk of diabetes by 67%.
- In another study, drinking over 21 diet drinks a week doubled the rate of obesity.
The data is unequivocal. Diet drinks and artificial sweeteners increase the risk of heart attacks, strokes, diabetes and an early death. The message couldn’t be clearer; avoid these drinks whenever possible.
What we don’t know is which sweeteners are responsible for these adverse health effects.
The most worrying artificial sweetener is aspartame (found in Diet Coke, Coke Zero and Sprite Zero) which has been controversial from the beginning. It has repeatedly been found to cause cancers in animals and was found to cause epilepsy and death in monkeys. It can cause migraine and interferes with essential neurotransmitters and can cause a syndrome with headaches, mood changes, dizziness and gut symptoms. All 165 studies that found aspartame safe were sponsored by industry and all that found aspartame unsafe were independent studies.
Sucralose is a chemical which is thought to damage beneficial gut bacteria, reducing them by up to 50%. It can trigger migraine and cause infertility and miscarriages in laboratory animals. In one study it significantly reduced the weight of the thymus (the major gland of our immune system) within 28 days of using sucralose.
Saccharin has been linked with bladder cancer in animals. Agave is a concern due to its high fructose content.
High fructose corn syrup (more a sugar substitute than a sweetener) can trigger metabolic syndrome, fatty liver and obesity and contains mercury residues.
Sugar alcohols, such as xylitol, can cause bloating, abdominal cramps and diarrhoea.
Stevia is a highly processed ingredient but may be the safest, although it may alter gut bacteria in negative way. At the moment it makes sense to avoid them all.