Does political risk deter FDI from emerging markets?
“Ask anyone you meet on the street whether political risk has risen in the last few years, and you’d likely get a convincing yes,” a high official from Canada’s Export Development Center recently wrote [1].
Investors have always worried about the political landscape in host markets. But it’s true. Concerns over political risk are on the rise.
The most recent EIU’s Global Business Barometer [2] shows that the proportion of executives that identified political risk as one of their main concerns increased from 36 percent in 2013 to 42 percent in 2014. MIGA’s Political Risk Survey [3]?
FDI from emerging markets now accounts for one third of total flows. Are these flows immune to political risk? Some say that emerging market investors enjoy an “adversity advantage” relative to their competitors from developed economies. The thinking here is that since emerging market investors are exposed to relatively poor business climates and more political instability at home, they are better equipped to deal with it abroad (e.g. Ramamurti, 2009; Guillén and García-Canal, 2012).
In New Voices in Investment [4], a survey of cross-border investors from four emerging economies-- Brazil, India, South Africa, and South Korea-- we broached this question.
At first glance, our findings suggest that firms from these countries that invest abroad are largely indifferent to non-economic aspects of the business environment, such as transparency of regulations, corruption, political stability, and expropriation risk. Less than 14 percent of investors identified one of these indicators of political risk as one of the two main factors informing their location decisions – only 4 percent of them identified political risk as the top investment consideration.
Yet, as we’ve argued in a previous post [5], asking existing investors about binding constraints is, to use Hausmann and Velasco’s (2005) analogy, like asking camels about the living conditions in the desert. This is why we also surveyed potential investors and non-investors (firms not interested in cross-border investment).
And indeed, we find that the answers given by these potential investors and non-investors on how binding political risk was to their decisions paint a different picture: Emerging market investors are clearly not indifferent to political unrest and instability.
Our survey shows that political risk is more of a deterrent for non-investors than for potential and actual investors. The more politically-risk averse self-select out of cross-border direct investment. While only 4 percent of actual investors ranked political risk as their top concern, when we asked potential investors and non-investors this number rose to 8 and 17 percent, respectively. Almost half of non-investors said that political risk was one of the two main location factors they looked at when considering a host market.
Indeed, these obstacles may prevent some firms from even considering investing abroad.
When asked about specific dimensions of political risk, all three categories of investors said they worried about lack of transparency in business regulations and political instability-- their top non-economic concerns-- more than they worried about corruption and expropriation risk (figure 1).
Are these reported concerns based on actual experience, sentiment, or both? When we asked investors if they had encountered infringements on contracts or post-investment changes in regulations and taxation policies, a significant majority said they had not. Only around 10 percent of firms said they had suffered from host governments breaching agreements made prior to investment.
A more serious risk is a lack of stability in domestic regulations. Almost 17 percent of investors reported having to confront changes in regulations and taxation that impaired their profitability. These results are consistent with the findings of the MIGA Political Risk Survey, which show that breach of contract and regulatory instability are the most important political risks for foreign investors (figure 2).
Our surveys also show that some firms are more risk-averse than others. It’s the more export-oriented companies, and those from India and South Korea, that care most about political risk. This is reasonable considering these firms are often part of international production networks and face greater costs of unexpected changes in regulations that may disrupt just-in-time, just-in-sequence processes.
Policymakers should take stock of these findings and learn from not only the experiences and concerns of incumbent firms, but also those of the firms that self-select out of investment. Attracting new firms will require addressing constraints on both.
- Emerging Economies [6]
- FDI [7]
- investment [8]
- Trade [9]
- Private Sector Development [10]
- Global Economy [11]
- The World Region [12]
- Korea, Republic of [13]
- South Africa [14]
- India [15]
- Brazil [16]