David Crowe, attorney at law, believes someone should stand up for the rights of bicycle riders. And with more than 200 bike-related cases under his belt, the former pro cyclist may be just the man to take up the torch.
When cyclists are hit by cars and become entangled in haggling with insurance companies over medical costs or wrecked bikes, that's when Crowe -- Athens' best-known bicycle barrister -- steps in and either files suit or negotiates a settlement. Of 50 cases Crowe has taken to trial involving cars vs. bikes, he's lost exactly zero. Now, about 80 percent of defendants will settle before they risk their case in front of a jury.
He's become so well-known for his legal acumen in biking circles that local bike shop owners and clerks keep his business card on hand and have been known to shout Crowe's name out as they ride by cyclists who've taken a spill -- ''Go see David Crowe!''
Crowe, 38, has practiced personal injury law for 11 years, including the past six years on his own. A former rider for the Athens Bandag national team, he still takes a mountain bike trek every summer in Montana.
Crowe's specialty of bicycle litigation came as a natural mix of his hobby and career. Retired from the road race circuit and fresh out of law school at Cal Western San Diego, Crowe began hearing story after story from fellow Athens bike riders who felt they were wronged in collisions with cars.
''Nine times out of 10, the bicycle is going to be blamed for the wreck,'' Crowe said. ''It was really an unbelievable pattern. Even in the most egregious cases, the officers would find fault with the rider.''
There are two types of car-bike collisions that are most common on the road, Crowe said. In one scenario, a motorist will zip around a bicycle rider and attempt a right turn in front of the bike. The other most common instance is when a motorist simply doesn't see a cyclist and turns left in front of the rider. In both cases, the cyclist meets sheet metal in a hurry.
''In every single case, I've never seen a motorist cited,'' Crowe said.
He believes there is a standing bias among many motorists, jurors and police against bicycle riders, though with the advent of bicycle police, ''the pendulum is swinging back a little bit,'' he said.
''A lot of motorists think if they see a bicycle on the roadway, it really should not be there,'' Crowe said. ''They think the cyclists need to get out of their way.''
Gene Dixon, owner of Dixon's Bicycles in Athens, said it only takes a few folks with negative attitudes toward cycling to create a bad atmosphere for riders.
''I don't think the percentage (of people with bias) is that high, but it doesn't take that many people with that attitude to create that feeling on the roads,'' Dixon said.
Insurance adjusters often scoff when they get damage estimates from Crowe for high-end bikes mangled in auto collisions. Representing serious road cyclists with serious equipment, Crowe has sought property damage compensation for bikes costing as much as $5,000.
''When we send these estimates in for the amount of damage, generally adjusters call and say, 'I think you've misplaced a decimal point,' '' Crowe said.
Dixon, who has appeared in court as an expert witness for Crowe, said lowballing by insurance companies is typical in bike accidents.
''It's really easy for an insurance company to want to try to do that,'' Dixon said. ''There is that attitude that I don't think these (cyclists) have the resources to defend themselves, so we'll try to nail them. David comes in and stands up for them.''
''We're very reasonable in what we ask for,'' Crowe said, ''but on the other hand, we don't lay down and allow ourselves to be run over.''
''The nice thing about David is he's a cyclist, so he understands not only what the equipment is worth, he also knows a lot of inside things about cycling that maybe a normal attorney wouldn't know,'' said Steve Sevener, a professional cyclist who runs Atlantis Hydroponics on Baxter Street.
Crowe helped litigate two cases in which Sevener was struck by a car on his bike. Sevener said Crowe, who is also known for his encyclopedic knowledge of Athens roads, has ''helped just about everybody I know when it comes to bikes.''
''Aside from being a cyclist, and knowing what they have to deal with on the road, he's really a good attorney and in tune with the cyclist's needs,'' Sevener said.
Crowe said that while he always has at least one or two bicycle accidents among his caseload, they only account for about a third of his business. Many cases, especially those involving only property damage, bring in little money.
''In many cases, I don't expect to earn much income off of it, I'm just advocating the rights of cyclists,'' said Crowe. ''If someone wants to call up and talk about cycling, they'll get in right away."