November 2, 2021
Kurt Squire Shares Lessons Learned In ‘Making Games for Impact’
How do you tap into people’s passion for gaming to improve learning outcomes and positively influence society? Kurt Squire tackles this question in his new book, Making Games for Impact, sharing lessons learned from real-world projects.
Informatics Professor Kurt Squire is a leading scholar in games research and development.
As educators struggled to effectively leverage technology during the COVID-19 pandemic, the gaming industry experienced tremendous growth, revealing both the problems and potential of expanding computer games beyond just entertainment. Over the next five years, game-based learning is expected to reach a market size of $17 billion, but how do you design and develop games that actually make a difference? Drawing from two decades of experience in games research and development, Informatics Professor Kurt Squire offers lessons learned in his new book, Making Games for Impact (MIT Press, 2021). His experience stems from the Games + Learning + Society center, which he started with Constance Steinkuehler in 2005 at the University of Wisconsin-Madison and recently relaunched in the Donald Bren School of Information and Computer Sciences (ICS) at UCI. Presenting a series of case studies from the center, Squire examines how to make games for impact, also touching on innovation and entrepreneurship in higher education.
What was your motivation for writing this book?
As game design becomes mainstream, we’re seeing more teams making games for impact — whether it’s in learning, healthcare or personal growth. A lot of what we wrestled with was about taking innovations out of the university and into the marketplace. How do we leverage university expertise to partner with commercial teams? Or is it better to spin out student companies? After almost 10 years of projects supported by $10 million in grant funding, we created many successful products and partnerships — and made some mistakes — so I wanted to share our experiences before it went cold.
And why look at impact in particular?
I like to think of “impact” instead of just learning, because some people think of learning in narrow terms. Most game projects are really trying to make an impact in the world beyond learning gains.
Why focus on individual case studies?
I find that people learn the most from stories — or case studies. Each case study is designed to illustrate a specific point, like how do you build up an art team? Or how can you use analytics in design? Each chapter does report on more focused research studies, but a book lets us tie these studies together so that hopefully, a reader can sense what it is all trying to add up to.
Who is your target audience, and what do you hope they take away from this book?
The target audience is anyone from people in games or game studies interested in how we design them for impact, to educators curious about games. I also hope that teams building games for impact — from educators making a math game to people working in healthcare — will want to read and share the book with their teams because they’ll see themselves in there somewhere. My hope is that they’ll read portions and think, “Oh, we are about to make that mistake! I should share this and we should discuss it first.”
How do you think the pandemic impacted digital games for learning?
On the one hand, kids (and people) turned to games more than ever outside of school. Games, as an industry, exploded. We turned to Animal Crossing, Among Us, and Minecraft for comfort, friendships or adventure. We collaborated, shared, constructed and celebrated in virtual worlds. Yet in schools, technology was mostly implemented in a pretty conservative way. With few exceptions, we mostly used technology for displaying lectures and submitting homework. My hope is that the pandemic really alerted people to the possibilities of game-based learning technologies. I’m hoping that many people asked why they can create virtual societies or structures in Minecraft, but in schools, [they just] more or less repeat back what teachers want them to do.
When people ask about successful games for learning, I point them to Plague Inc., a game about designing a pathogen to wipe out humanity. It’s been in the top 10 mobile games for the better part of the past decade now. Play that game and you understand all kinds of ideas central to viruses and managing the pandemic.
You mentioned moving innovations from academia into the marketplace. Can you expand on that?
We live in what’s been called an “entrepreneurial age” of the university. With reduced tuition dollars and uncertain federal funding, universities are looking for ways to diversify income. Academics struggling to make sense of this “entrepreneurial university” might look to colleagues in games for lessons on navigating the modern university structure. Games, as a discipline and as an activity, have come of age in this milieu.
Many scholars teach in cost recovery or professional programs and have had to build up staff through creative project management, so our field has learned a lot about navigating these structures. This book offers lessons not just about games but also about navigating universities and institutions generally, such as how to choose projects, how to partner with administration, and how to grow teams through diverse funding sources.
A big lesson I learned was that it is critical for innovators to ask, “Whose problems does this innovation solve?” We often focus on our own problems (i.e., revenue, student learning), but those may not be the problems of administrators. What most administrators are really interested in is accruing social and cultural capital. The book ends with some reflections on how innovations can thrive within the modern university by aligning with broader institutional goals and exploiting niches in the environment.
Any current projects in the works through the Games + Learning + Society center?
We’re working on many projects now, particularly around well-being, attention focusing and remote collaboration, as well as entrepreneurship with XR [extended reality] during the pandemic.
About the Author
Kurt Squire is a professor of informatics and author of several books, published games and scholarly articles about games for impact. His work has been funded by the NSF, Department of Education, NIH, and the Gates and MacArthur Foundations, among others.
— Shani Murray
Kurt Squire Shares Lessons Learned In ‘Making Games for Impact’< Previous
Computer Science Ph.D. Student Vikram Narayanan Receives IBM Fellowship