levothyroxine sodium (L-thyroxine, T4) Nursing Considerations & Management
Drug Name
Generic Name : levothyroxine sodium (L-thyroxine, T4)
Brand Name: Levothroid, Levoxine, Levoxyl, Synthroid, Thyro-Tabs, Unithroid
Classification: Thyroid hormone
Pregnancy Category A
Dosage & Route
Available forms : Tablets—25, 50, 75, 88, 100, 112, 125, 137, 150, 175, 200, 300 mcg; powder for injection—200, 500 mcg/vial
Dosages : 50–60 mcg equals approximately 60 mg (1 grain) desiccated thyroid.
ADULTS
- Hypothyroidism: Initial dose, 50 mcg PO, with increasing increments of 25 mcg PO q 6–8 wk; maintenance of up to 200 mcg/day. IV or IM injection can be substituted for the oral dosage form when oral ingestion is not possible. Usual IV dose is 50% of oral dose. Start at < 25 mcg/day in patients with long-standing hypothyroidism or known cardiac disease. Usual replacement 1.7 mcg/kg/day.
- Myxedema coma without severe heart disease: 200–500 mcg IV as initial dose, then 100 to 200 mcg IV daily; daily maintenance of 50 to 100 mcg once a euthyroid state is established. Switch to PO once patient is able. Full effect not seen for 24 hr; dose based on improvement.
- TSH suppression in thyroid cancer, nodules, and euthyroid goiters: Larger amounts than used for normal suppression.
- Thyroid suppression therapy: 2.6 mcg/kg/day PO for 7–10 days.
- Older patients may require less than 1 mcg/kg/day. For most patients older than 50 yr or under age 50 with cardiac disease, an initial dose of 12.5 to 25 mcg/day with increases of 25 mcg/day q 4–6 wk.
PEDIATRIC PATIENTS
- Congenital hypothyroidism: Infants require replacement therapy from birth.
- 0–1 yr: 8–15 mcg/kg/day.
- 1–5 yr: 5–6 mcg/kg/day.
- 6–12 yr: 4–5 mcg/kg/day.
- > 12 yr: 2–3 mcg/kg/day.
Therapeutic actions
- Levothyroxine sodium increases the basal metabolic rate (BMR) of carbohydrates, fats and proteins. It is also involved in the regulation and differentiation of cell growth. These effects are mediated at the cellular level by the thyroxine metabolite, tri-iodothyronine.
Indications
- Replacement therapy in hypothyroidism
- Pituitary TSH suppression in the treatment and prevention of euthyroid goiters and in the management of thyroid cancer
- Thyrotoxicosis in conjunction with antithyroid drugs and to prevent goitrogenesis, hypothyroidism, and thyrotoxicosis during pregnancy
- Treatment of myxedema coma
Adverse effects
-.
Contraindications
- Untreated hyperthyroidism; uncorrected adrenal failure; recent MI.
Nursing considerations
Assessment
- History: Allergy to active or extraneous constituents of drug, thyrotoxicosis, acute MI uncomplicated by hypothyroidism, Addison’s disease, lactation
- Physical: Skin lesions, color, T, texture; T; muscle tone, orientation, reflexes; P, auscultation, baseline ECG, BP; R, adventitious sounds; thyroid function tests
Interventions
- BLACK BOX WARNING: Do not use for weight loss; large doses may cause serious adverse effects.
- Monitor response carefully at start of therapy, and adjust dosage. Full therapeutic effect may not be seen for several days.
- Ensure that patient swallows tablet with a full glass of water.
- Do not change brands of T4 products, due to possible bioequivalence problems.
- Do not add IV doses to other IV fluids.
- Use caution in patients with CV disease.
- Administer oral drug as a single daily dose before breakfast with a full glass of water.
- Arrange for regular, periodic blood tests of thyroid function.
- For children and other patients who cannot swallow tablets, crush and suspend in a small amount of water or formula, or sprinkle over soft food. Administer immediately.
- WARNING: Most CV and CNS adverse effects indicate that the dose is too high. Stop drug for several days and reinstitute at a lower dose.
Teaching points
- Take as a single dose before breakfast with a full glass of water.
-. Keep your scheduled appointments.
- Report headache, chest pain, palpitations, fever, weight loss, sleeplessness, nervousness, irritability, unusual sweating, intolerance to heat, diarrhea.