Photo: Stewart Roper
As we wind down (or up) for Christmas and New Year, we look back at the year we’ve just had and consider how what has gone before will shape the environment for 2017.
At the national level, the biggest event was the Federal election on 2 July. Even though health figured as a major issue during the campaign there were limited promises of new funding and indeed the tightening of the belt (often for very small savings) has continued post-election.
These are times of austerity, of a focus on budget control, managing the economy, and reducing growth in government outlays. And this is not likely to change in the foreseeable future.
In such an environment it is not good enough simply to complain about lack of fairness and poorer rural health outcomes, nor just to have good ideas about how to improve access and equity for people in rural and remote Australia. We need to be:
- Strategic about identifying those few major changes which would have the biggest impact on health and wellbeing;
- Tactical in identifying concrete, on the ground actions which can be pursued both locally and nationally to achieve our strategic objectives;
- United in driving for implementation at local and national levels (and I have deliberately emphasised local first); and
- Clever in defining and demonstrating the economic and social value of improved outcomes for people in rural and remote areas.
The mantra from the Prime Minister during the election was “jobs and growth”. We all know that in the right conditions and with the right support rural and remote Australia CAN deliver jobs and growth. Investing in the wellbeing of rural and remote Australia is not only an investment to save (in terms of future health, disability and aged care costs) but also an investment to grow – to increase participation, productivity and economic growth.
So, let’s recognise the Prime Minister’s priorities and build on that potential strength of rural and remote people. The Alliance Board and Council have had some initial discussions about strategic priorities for the future, and first among these priorities is to unlock the economic and social value of the seven million people living in regional, rural and remote Australia by reducing the difference in their health and wellbeing outcomes compared with people living in cities.
Many Australians would see rural and remote Australia as the country’s lifeblood, the source of our proud heritage. Think farms, think mining, think our First Peoples, think of our rural towns and communities – the source of water, food and commodities, and around 50 per cent of export income.
Yet the economic drain on Australia due to the worse health outcomes experienced by people in rural and remote areas is enormous.
If we can reduce the disparities in health and wellbeing between people who live in rural and remote areas and those living in metropolitan areas, we can have a dramatic impact on both costs and the economy.
First, we can save present and future costs. By focusing on prevention and early intervention, reducing intergenerational cycles of poverty, supporting strong families and a healthy start to life for children, and on those at high risk of chronic complex diseases, we can significantly reduce costs.
For example, food insecurity in rural and remote areas, particularly for remote Aboriginal and Torres Strait Islander communities, means that children are less likely to have a healthy, nutritious diet. Yet we know that a healthy diet will give them a much better start to life, improve the ability to attend and participate at school, and reduce the likelihood of developing diabetes. And even where people do develop diabetes, access to the right foods will help them control their diabetes and reduce their risk of developing kidney disease.
Second, we know that healthier people and communities are more likely to be higher achievers in the education system, to be employed, and to spend, invest and save. By improving the wellbeing of people in rural and remote Australia, we can dramatically improve participation, stimulate innovation and productivity, and increase Australia’s economic growth.
But just saying this isn’t enough. In 2017 the Alliance will be working to identify the potential economic benefits to be gained by improving health outcomes for people in rural and remote areas and reducing the disparities with our city colleagues.
We’ll be working with stakeholders to identify concrete, on the ground proposals, to define and demonstrate the value of interventions over time, and to speak with one voice in the drive for local change.
In the current environment of devolution, regionalisation and localisation (for example, the increasing empowerment of Primary Health Networks or PHNs), a local approach is important.
It’s not about lots more money. It’s about changing priorities to focus on prevention and early intervention, rather than on intervening late at significant cost to the system and the economy, and suffering of individuals, families and communities.
It’s also not only about the Federal Government (although the Government has a significant leadership role). It’s about State and Territory governments, local government, private sector, community organisations, and service providers working with consumers, families and communities to come up with and implement local solutions to local issues.
The Alliance will also be working on other priorities, including the rural health workforce, Aboriginal and Torres Strait Islander health, social and emotional wellbeing, and cultural safety, the potential for the PHNs, and the best start in life for mothers and babies, focusing on the first 1000 days – from conception to the age of two.
It will be a tough agenda in tough times but it is achievable if we are united and focused, if we are clear on priorities and actions, pursue those actions consistently over time, and can demonstrate value. Certainly, it’s worth it for the millions of people we are here to support.
A happy, peaceful and safe Christmas and New Year for you, your families and your communities.
- Log in or register to post comments