A number of years ago, while searching through a postcard dealer’s stock, I came across a group of postcards reproducing many works of art, some by the most significant artists of the 20th century. Normally that wouldn’t be a very remarkable find, except that the cards had an imprint of a little-recognized art organization based in New York. The usual slog through hundreds of mundane New York City postcards finally resulted in something interesting!
The Société Anonyme, a group made up of some of the most avant-garde artists of its day, can rightfully claim to be New York’s first museum of modern art. The Société was the vision of Katherine Dreier, an early patron of modernism in the arts, and an artist in her own right. She was one of the first American abstractionists and one of the few female artists in the modern art movement. Before establishing the Société she spent much of her time in Europe, befriending many of the most avant-garde artists and art dealers.
Dreier was born in 1877 and came from a prominent and politically active Brooklyn family that instilled the value of education and civic responsibility in their children of both genders. She drew on her spiritual and philosophical beliefs and her social idealism to attempt to influence American attitudes towards contemporary art at a time when it was generally ill regarded and unappreciated by the masses. Unfortunately she is rarely credited with the enormous influence she had in establishing modern art in America.
In 1920 Dreier and her friend and infamous fellow artist Marcel Duchamp decided to form a new organization devoted to exhibiting and promoting modern art to Americans. (Duchamp was one of the most provocative Dada/Surrealist artists of his time. He is best known for his Cubist/Futurist-inspired painting Nude Descending a Staircase, No. 2 which scandalized the American audience at the 1913 Armory Show in New York City, and the urinal that he found and exhibited as the sculpture Fountain by the artist “R. Mutt”). They invited Man Ray, a Dada/Surrealist artist and avant-garde photographer to join them in their efforts.
It was Man Ray who came up with the name “Société Anonyme,” which he thought literally meant “Anonymous Society” in French. Duchamp informed him that in French the true meaning is equivalent to the English word “Incorporated.” Drier liked the name because it had the ring of impartiality – it put the focus on the art, not the individual artists and puts a capitalist spin on an anti-materialist art organization. Drier rented two small rooms at 19 East 47th Street in New York City for the exhibit space and the library of the fledgling organization. When it was officially incorporated in New York, it became more Dada joke since it now meant “Incorporated, Inc.”
On April 30, 1920, the Société Anonyme, with the now-appended title “Museum of Modern Art: 1920” had its first exhibition. Duchamp designed the space with a neutral, industrial look. The floor was ribbed rubber and the walls and woodwork were a pale blue. The exhibit featured the European artists Jacques Villon (half-brother of Marcel Duchamp), Alexander Archipenko, Juan Gris, Heinrich Vogler, Vincent van Gogh and the sculptor Brancusi. American artists included Joseph Stella, Patrick Henry Bruce, James Daugherty, and works by New York Dadaists Duchamp, Man Ray, Morton Schamberg and others.
Dreier had hoped to raise enough money to establish a permanent space to exhibit modern art, but wasn’t successful. She gave up the 47th Street space after a year but the Société Anonyme continued to function as a museum-without-walls by holding exhibits, lectures and symposia in other galleries, clubs, workers’ centers and rental spaces. The Société also produced publications and had an acquisitions program. It continued to draw on the talents of international artists including Cubists, Dadaists, Futurists, Expressionists, Constructivists and other progressive artistic genres.
Drier’s real hope of founding the first permanent museum of modern art in the United States was eclipsed when the Museum of Modern Art (now commonly referred to as MoMA) in New York City was established in 1929 by a more diplomatic Alfred Barr, the museum’s founding director, with very substantial financial backing from its most prominent supporters.
Villon Duchamp drawing on Society Anonyme postcard.
The postcards shown here are all from the Société’s first year on East 47th Street. Oddly enough these postcards are all real photo postcards that can hardly do justice to some of the most colorful and exciting artworks of that time. Other artists whose work is shown on the postcards (and are not already mentioned above) are Louis Eilshemius, Pablo Picasso, Kurt Schwitters, Heinrich Campendonk and R. Villon-Duchamp (brother of Marcel Duchamp).
On one hand, these can be thought of as mere “museum” cards in that they are simply reproductions of artworks on postcards. In the postcard world this type of card is rarely given much notice, let alone monetary value. However, here we have evidence of the original visionary efforts to promote some of the most significant artists of the 20th century from an organization that was instrumental in fostering the recognition and appreciation of modern art in America. As such, in my opinion, they have a status of their own.
Despite the establishment of the Museum of Modern Art, Dreier still maintained hope of a permanent museum, even planning to open “The Country Museum” at her West Redding, Conn., home, which would feature her own collection and the Société’s. Again she could not get enough backing and in 1941 the Société’s collection was sent to Yale University. Through the 1940s she continued to lecture and acquire art on behalf of the Société. On April 30, 1950, the 30th anniversary of the first exhibition of the Société Anonyme, the Société was dissolved at a dinner given by Dreier and Duchamp. Dreier died in 1952.