The budget scandal now engulfing New York’s City Council, in which staffers have allocated money to fictitious groups and two workers have been charged with bilking taxpayers out of some $145,000, is just the latest in a long line of controversies involving city funding of nonprofits. These scandals periodically emerge because in today’s political landscape, elected officials use money designated for nonprofits to buy and keep political influence. Not surprisingly, then, they do everything they can to keep this money free from oversight.
Nearly 15 years ago, the city’s Financial Control Board identified the growing problem when it released a blistering report on the city’s contracting of services from nonprofits. The report pointed out that New York was failing to keep accurate records of its dealings with these organizations and doing little to ensure that nonprofits receiving city dollars fulfilled their contractual obligations. In many cases, the city government awarded contracts without competitive bidding, and it rarely evaluated the nonprofits’ performance.
In the wake of the report, city agencies reformed some of their contracting practices. But City Council members managed to keep a big pot of money safe from the new, stricter contracting requirements. This money, reserved for so-called “member items” (a euphemism in many cases for pork-barrel spending) and for so-called council “initiatives” (discretionary spending that the speaker doles out), has been at the center of various funding controversies in the past.
The underlying problem is the central role that nonprofits now play in politics, which has been shaped by the huge pots of money that government steers their way. Decades ago, nonprofits were known by their old-fashioned name: charities. They derived most of their income from private donations and based their agendas on the needs of those they wished to serve. Then the Johnson administration’s War on Poverty, begun in the mid-1960s, turned the charities into government agents who would run programs designed to help the poor. The feds allocated billions of dollars to nonprofits through direct grants or via money funneled through state and local government agencies. In the process, the federal government paid nonprofits to do everything from running homeless shelters and rehabilitation programs for drug addicts to opening job training centers and designing and operating preschool programs. In just a few years, the money turned many charities into government contractors, reliant on public funding and serving an agenda set by Washington or local governments. The sudden availability of so much government money also prompted enterprising individuals to get into the public-contracting game and create new nonprofits of their own.
The subsequent growth of the nonprofit sector has been considerable. In 1975, about 52,000 jobs in New York City were devoted to private social services. Today, though the city’s population has increased only slightly since the mid-1970s, social-services jobs number more than 160,000, making them one of the fastest-growing sectors. Indeed, private social services now rival Wall Street as one of Gotham’s biggest employers; three times as many people work in private social agencies as in publishing. But while these service jobs are counted as part of the private sector, they’re financed almost entirely with government money. The industry continues to rely for its growth on expanding government budgets, fueled by tax collections.
Further, many nonprofits have become political power bases, replacing the local political clubhouses of the 1960s. Executives and founders of nonprofits have used their agencies as launching pads for political careers, so that today a job in the nonprofit sector is as likely a route to the City Council or the state legislature as being a lawyer and member of a local political machine once was. And channeling money into nonprofit groups is a sure way for a legislator to win friends and influence people.
To do that, of course, legislators have to be free to contribute to groups they favor—and that means ensuring that taxpayers’ money is not subject to rigorous bidding procedures, which might exclude the favored groups. Three years ago, for instance, councilwoman Margarita Lopez sparked controversy when she gave hundreds of thousands of her member-item dollars to a detoxification program for 9/11 workers that was run by Scientologists and that, experts claimed, had no basis in legitimate science. Lopez had made the grants using council funds that carried no requirement for competitive bidding or evaluation of program effectiveness. Eventually, members of the church made more than $100,000 in donations to her campaign for Manhattan borough president.
When oversight is so thin, bad things can happen to taxpayers’ money. In the latest scandals, two council staffers face indictments for allegedly embezzling money channeled into a nonprofit that one of them created and controlled. New Yorkers have also learned that for at least seven years, City Council staffers have created phony nonprofit groups and allocated money to them as a way of parking cash that could be dispensed later.
Because of the powerful role that nonprofits now play in the political process, council members are resisting new efforts to regulate their discretionary giving. They’ve opposed Mayor Bloomberg’s call to move all but the very smallest council grants—those of $10,000 or less—into the city’s competitive-bidding process. Council members claim that ceding that control to the mayor threatens their “independence.” Experience tells us, however, that allowing the council to continue its broad discretionary use of public money threatens something else—the fiscal integrity of New York’s budget process. Taxpayers deserve better.