It won’t surprise you that AUNE’s Department of Clinical Psychology, launched thirty years ago, was innovative right from the start.
“Even from the beginning, we imagined ourselves as visionaries,” said Roger Peterson, professor and Distinguished Senior Scholar in the Department of Clinical Psychology, who joined the first PsyD faculty in the fall of 1982. “Coming out of the seventies, we were less hierarchical and more open to new ways of thinking. We were alternative! We were really trying to do something different in clinical psychology education.”
That something was to educate psychologists as practitioner-scholars, well-rounded clinicians with a broad range of skills and competencies who would be integrated into their communities, especially important in rural New England. It ran counter to the typical doctoral program of the day which trained people in narrow research areas, with an academic rather than practical focus.
It put AUNE at the leading edge of an emerging Doctor of Psychology (PsyD) movement which emphasized preparing graduates for clinical practice as a primary focus. It educated students through an inclusive, generalist philosophy that taught many different approaches to practicing psychology and the many roles that graduates might be called on to play in their vocations.
At the Beginning
When the program opened in June 1982, AUNE was located on Roxbury Street. It was the beginning of the expansion of psychological services across the country. AUNE’s PsyD program was initially directed by David L. Singer, who was also director of AUNE’s master’s in psychology program and taught at AUNE from 1977 to 1993.
Twenty students were admitted that first semester, ten in the first-year program and ten in the second-year program. In 1982, there were just two full-time core faculty members, David Singer and Roger Peterson. There were some part-time faculty too, Colby Smith, who has been with AUNE since 1977. At the time, matriculating students were required to have a master’s degree, a requirement that was dropped in the early 1990s. (Now, about 25 percent of students entering the PsyD program have a master’s.) There were only twenty-six PsyD programs in the United States; now there are at least three times that number, but AUNE’s is still the only clinical psychology doctoral program in New Hampshire. The American Psychological Association awarded the program its first accreditation in 1986.
The PsyD had been essentially founded by Donald Peterson, professor of psychology at Rutgers University and a mentor to Roger, in the 1960s. In the 1990s, Roger and some national colleagues went on to develop the professional training model now used by most PsyD programs in the country. One element of that model is the Professional Seminar, originated at AUNE as part of our practitioner-scholar approach to clinical psychology. The ProSem model asks students, working in groups, to regularly learn academic material, examine self-in-role, and discuss their clinical work. It promotes self-reflection said Colby, now a professor of clinical psychology, who started as an adjunct faculty member at AUNE in 1977.
Focus on Rural Mental Health
AUNE PsyD faculty were leaders in training psychologists who would be practicing in rural areas. At the time there were only a handful of psychologists in New England. “We were building a program that had enhancing of rural mental health as one of its goals,” Colby said. “(Adult learners) could drive here one or two days a week; they didn’t have to move to the city. We thought of it as community intervention. Now our graduates are practicing and supervising all over New England.”
Roger had taught and practiced in the rural Upper Peninsula of Michigan before coming to AUNE. “We were all grounded in the interpersonal, the philosophy that the central things that are curative are a person’s relationships, and you have to understand the person within context, he said. Because we were in a rural area, we were going to be practicing in all kinds of contexts and you had to have exposure to all kinds of settings. So AUNE’s approach was intentionally generalist, to prepare graduates for the variety and complexity of circumstances they would face.”
AUNE’s PsyD department itself had a close sense of community. “We were small enough to have a community model and discuss training issues over dinner. Also, a group of early faculty had a group private practice together,” Roger said. “The faculty was more collaborative, consistent with the times but different than many academic programs at the time.”
Today there are more core faculty members than there were a quarter century ago. More students and faculty live in the Keene area, and the students are generally younger these days.
During the 1990s, Singer, Peterson, and Kathi Borden, the current chair of the PsyD program, all served as presidents of the National Council of Professional Schools (NCSSP), a major distinction for the program. Their influence helped move NCSPP educational model into the national arena.
PsyD Centers Involve Community
Several centers housed in the PsyD Department reflect faculty and student involvement in the community. Two years before AUNE left Roxbury Street for Avon Street, the PsyD Department opened the Psychological Services Center, a training clinic for PsyD students which offers mental health services to community members. “We made a commitment to having an important part of our training here; our faculty supervises them, and through the clinic we are involved with the community,” Colby said.
The Center for Research on Psychological Practices (CROPP) was founded in 1996 as a research center incorporating applied clinical research and evaluation skills, especially in the area of health care systems.
In 2000, the Multicultural Center for Research and Practice was started to foster multiculturalism, social justice, and, through its support of Support Group for Ethnic and Racial Diversity (SERD)/Disaster Shakti, community service. It reflects the philosophy that AUNE’s PsyD program was built on thirty years ago.
The spirit that was at the beginning is still here today, we are for social justice and I think we were from the beginning, Roger said. The relationship and growth of people as professionals is also here. It’s deep in the roots of AUNE.