WordPress SEO by Yoast and Jetpack are two of the most installed plugins by WordPress users. One of the most popular modules of Jetpack is Publicize, the feature that lets users post updates of new articles to Facebook, Twitter, LinkedIn and Tumblr.
Unfortunately, when it comes to posting updates to Facebook, WordPress SEO by Yoast and Jetpack do not play nice together. What you will find is that Jetpack will post your article to Facebook on schedule with the correct link, however the wrong thumbnail will be used. This usually leads to less click throughs to your posts.
This was a problem I had before on this blog though I faced them again on my relaunched blog Martial Arts Videos. Before I show you how to resolve the problem, let’s look at what actually happens.
The Jetpack & WordPress SEO Facebook Thumbnail Problem
When WordPress SEO by Yoast and Jetpack play nice, Jetpack posts about your new article on your Facebook page with the correct thumbnail. This worked correctly for my post The Future of Martial Arts.
As that article updated correctly on Facebook, I wrongly assumed that everything was working correctly. The article published the following day focused on martial arts legend Bolo Yeung. As you can see, the wrong thumbnail was used. For some reason, the Back to the Future thumbnail that was used in the previous article was used again. It was later used on two or three more articles incorrectly as well.
This is what the article should have looked like. This would have got many more clicks because the photo matches the article title and content.
Fixing the Problem
The thumbnail problem arises because of Jetpack and Facebook both adding Facebook Open Graph tags (known as og tags). The first thing you need to do to resolve this issue is stop Jetpack from adding og tags. To do this, simply add this piece of code to your theme’s functions.php template.
// remove Jetpack og tags
remove_action('wp_head','jetpack_og_tags');
The next thing you need to do is go to the social section of WordPress SEO and ensure that the option to “Add OpenGraph meta data” is checked (it is right at the top underneath Facebook OpenGraph).
Once you have add completed both of your steps, you should find that the thumbnail problem has been resolved. If you do not want to wait until your next article is published, you could create a dummy post on your blog with a thumbnail and publish it. Then check if Facebook has posted correctly and then quickly delete the post on your blog and the update on Facebook.
I recommend checking the support forum for Jetpack on WordPress.org if you are still having problems with this as you will find many problems about the issue (such as this one, this one or this one)
Other Issues You May Come Across
If you have everything configured correctly and something goes wrong with your Facebook update, do not automatically assume that it was caused by Jetpack. Sometimes the problem lies with Facebook.
Jetpack sometimes appends fb_source=pubv1 to articles when they are sent to Facebook. When this happens, the thumbnail does not seem to generate.
The issue with fb_source=pubv1 is being experienced with many Jetpack users. According to Automattic Jeremy Herve, Facebook allows you to append parameters to URL’s and it should not affect how a thumbnail is generated.
Perhaps the fb_source=pubv1 issue does cause problems with Facebook, however Facebook itself is temperamental at times. The article, 15 Amazing Tony Jaa Fight Scenes, was one which I planned on getting a lot of shares. So when the thumbnail didn’t generate because of the fb_source=pubv1 issue, I deleted the update on Facebook and tried to add the link manually. This normally generates a thumbnail correctly every time but it simply would not work. I tried several times and a thumbnail would not generate.
It seems that Facebook does not always generate thumbnails for posts. I am unsure why. I know that Facebook looks for an image that is at least 200×200 pixels in size, but there doesn’t seem to be any other reason why a thumbnail wouldn’t generate.
One resource you may find useful in this regard is the Facebook Object Debugger. That will highlight any issues you have with your Facebook setup. When I entered the URL for my article, it said that were some like and open graph settings that had to be fixed.
I started looking at what needed to be fixed. As you know, to incorporate something like a Facebook like box on your page, you need to add code just below your opening body tag and to the area you want to add your like box. The code that is added just after your opening body tag controls everything Facebook related on your website. So before looking into what the problems were with my site, I simply logged into the Facebook developer area and created a new app for my website.
Thankfully, this seemed to resolve the issue with my thumbnail not posting and I was able to share my article properly on Facebook. If you are having the same issues I did, I recommend creating a new app and seeing if that resolves your problem.
I hope you have found this article useful 🙂
Kevin